/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.UiRequiredException;
import com.microsoft.identity.common.internal.commands.BaseCommand;
import com.microsoft.identity.common.internal.commands.CommandCallback;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.result.GenerateShrResult;
import java.util.List;

public class GenerateShrCommand
extends BaseCommand<GenerateShrResult> {
    private static final String TAG = GenerateShrCommand.class.getSimpleName();

    public GenerateShrCommand(@NonNull GenerateShrCommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback<GenerateShrResult, BaseException> callback, @NonNull String publicApiId) {
        super((CommandParameters)parameters, controllers, callback, publicApiId);
    }

    @Override
    public GenerateShrResult execute() throws Exception {
        String methodName = ":execute";
        GenerateShrResult result = null;
        GenerateShrCommandParameters parameters = (GenerateShrCommandParameters)this.getParameters();
        for (int ii = 0; ii < this.getControllers().size(); ++ii) {
            BaseController controller = this.getControllers().get(ii);
            Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
            result = controller.generateSignedHttpRequest(parameters);
            if (null == result.getErrorCode()) continue;
            String errorCode = result.getErrorCode();
            String errorMessage = result.getErrorMessage();
            if ("no_account_found".equalsIgnoreCase(errorCode)) {
                if (this.getControllers().size() > ii + 1) continue;
                throw new UiRequiredException(errorCode, errorMessage);
            }
            throw new ClientException(errorCode, errorMessage);
        }
        return result;
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return false;
    }
}

