/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.BrokerResultAdapterFactory;
import com.microsoft.identity.common.internal.result.IBrokerResultAdapter;
import com.microsoft.identity.common.logging.Logger;

public final class BrokerActivity
extends Activity {
    public static final String BROKER_INTENT = "broker_intent";
    static final String BROKER_INTENT_STARTED = "broker_intent_started";
    static final int BROKER_INTENT_REQUEST_CODE = 1001;
    private static final String TAG = BrokerActivity.class.getSimpleName();
    private Intent mBrokerInteractiveRequestIntent;
    private Boolean mBrokerIntentStarted = false;
    private Boolean mBrokerResultReceived = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.mBrokerInteractiveRequestIntent = (Intent)this.getIntent().getExtras().getParcelable(BROKER_INTENT);
        } else {
            this.mBrokerInteractiveRequestIntent = (Intent)savedInstanceState.getParcelable(BROKER_INTENT);
            this.mBrokerIntentStarted = savedInstanceState.getBoolean(BROKER_INTENT_STARTED);
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.mBrokerIntentStarted.booleanValue()) {
            this.mBrokerIntentStarted = true;
            this.startActivityForResult(this.mBrokerInteractiveRequestIntent, 1001);
        }
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        if (!this.mBrokerResultReceived.booleanValue()) {
            this.returnsExceptionOnActivityUnexpectedlyKilled();
        }
        super.onDestroy();
    }

    private void returnsExceptionOnActivityUnexpectedlyKilled() {
        IBrokerResultAdapter resultAdapter = BrokerResultAdapterFactory.getBrokerResultAdapter(SdkType.MSAL);
        Bundle resultBundle = resultAdapter.bundleFromBaseException(new ClientException("Broker request cancelled", "The activity is killed unexpectedly."), null);
        Intent data = new Intent();
        data.putExtras(resultBundle);
        data.setAction("return_interactive_request_result");
        data.putExtra("com.microsoft.identity.client.request.code", 1001);
        data.putExtra("com.microsoft.identity.client.result.code", 2001);
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).sendBroadcast(data);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(BROKER_INTENT, (Parcelable)this.mBrokerInteractiveRequestIntent);
        outState.putBoolean(BROKER_INTENT_STARTED, this.mBrokerIntentStarted.booleanValue());
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        String methodName = ":onActivityResult";
        Logger.info(TAG + ":onActivityResult", "Result received from Broker Request code: " + requestCode + " Result code: " + requestCode);
        this.mBrokerResultReceived = true;
        if (resultCode == 2004 || resultCode == 2001 || resultCode == 2002) {
            Logger.verbose(TAG + ":onActivityResult", "Completing interactive request ");
            data.setAction("return_interactive_request_result");
            data.putExtra("com.microsoft.identity.client.request.code", 1001);
            data.putExtra("com.microsoft.identity.client.result.code", resultCode);
            LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).sendBroadcast(data);
        } else {
            this.returnsExceptionOnActivityUnexpectedlyKilled();
        }
        this.finish();
    }
}

