/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;

public final class CacheRecord
implements ICacheRecord {
    private final AccountRecord mAccount;
    private final AccessTokenRecord mAccessToken;
    private final RefreshTokenRecord mRefreshToken;
    private final IdTokenRecord mIdToken;
    private final IdTokenRecord mV1IdToken;

    @Override
    public AccountRecord getAccount() {
        return this.mAccount;
    }

    @Override
    public AccessTokenRecord getAccessToken() {
        return this.mAccessToken;
    }

    @Override
    public RefreshTokenRecord getRefreshToken() {
        return this.mRefreshToken;
    }

    @Override
    public IdTokenRecord getIdToken() {
        return this.mIdToken;
    }

    @Override
    public IdTokenRecord getV1IdToken() {
        return this.mV1IdToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheRecord that = (CacheRecord)o;
        if (this.mAccount != null ? !this.mAccount.equals(that.mAccount) : that.mAccount != null) {
            return false;
        }
        if (this.mAccessToken != null ? !this.mAccessToken.equals(that.mAccessToken) : that.mAccessToken != null) {
            return false;
        }
        if (this.mRefreshToken != null ? !this.mRefreshToken.equals(that.mRefreshToken) : that.mRefreshToken != null) {
            return false;
        }
        return this.mIdToken != null ? this.mIdToken.equals(that.mIdToken) : that.mIdToken == null;
    }

    public int hashCode() {
        int result = this.mAccount != null ? this.mAccount.hashCode() : 0;
        result = 31 * result + (this.mAccessToken != null ? this.mAccessToken.hashCode() : 0);
        result = 31 * result + (this.mRefreshToken != null ? this.mRefreshToken.hashCode() : 0);
        result = 31 * result + (this.mIdToken != null ? this.mIdToken.hashCode() : 0);
        return result;
    }

    CacheRecord(AccountRecord account, AccessTokenRecord accessToken, RefreshTokenRecord refreshToken, IdTokenRecord idToken, IdTokenRecord v1IdToken) {
        this.mAccount = account;
        this.mAccessToken = accessToken;
        this.mRefreshToken = refreshToken;
        this.mIdToken = idToken;
        this.mV1IdToken = v1IdToken;
    }

    public static CacheRecordBuilder builder() {
        return new CacheRecordBuilder();
    }

    public String toString() {
        return "CacheRecord(mAccount=" + this.getAccount() + ", mAccessToken=" + this.getAccessToken() + ", mRefreshToken=" + this.getRefreshToken() + ", mIdToken=" + this.getIdToken() + ", mV1IdToken=" + this.getV1IdToken() + ")";
    }

    public static class CacheRecordBuilder {
        private AccountRecord account;
        private AccessTokenRecord accessToken;
        private RefreshTokenRecord refreshToken;
        private IdTokenRecord idToken;
        private IdTokenRecord v1IdToken;

        public CacheRecordBuilder mAccount(@NonNull AccountRecord account) {
            if (account == null) {
                throw new NullPointerException("The account record for a CacheRecord may not be null");
            }
            this.account = account;
            return this;
        }

        CacheRecordBuilder() {
        }

        public CacheRecordBuilder account(AccountRecord account) {
            this.account = account;
            return this;
        }

        public CacheRecordBuilder accessToken(AccessTokenRecord accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public CacheRecordBuilder refreshToken(RefreshTokenRecord refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public CacheRecordBuilder idToken(IdTokenRecord idToken) {
            this.idToken = idToken;
            return this;
        }

        public CacheRecordBuilder v1IdToken(IdTokenRecord v1IdToken) {
            this.v1IdToken = v1IdToken;
            return this;
        }

        public CacheRecord build() {
            return new CacheRecord(this.account, this.accessToken, this.refreshToken, this.idToken, this.v1IdToken);
        }

        public String toString() {
            return "CacheRecord.CacheRecordBuilder(account=" + this.account + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", idToken=" + this.idToken + ", v1IdToken=" + this.v1IdToken + ")";
        }
    }
}

