/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.ui.webview.ExpectedPage;
import com.microsoft.identity.common.internal.ui.webview.OnPageCommitVisibleCallback;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ChallengeFactory;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.NtlmChallenge;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.NtlmChallengeHandler;
import com.microsoft.identity.common.internal.util.StringUtil;

public abstract class OAuth2WebViewClient
extends WebViewClient {
    private static final String TAG = OAuth2WebViewClient.class.getSimpleName();
    private final IAuthorizationCompletionCallback mCompletionCallback;
    @NonNull
    private final OnPageLoadedCallback mPageLoadedCallback;
    @Nullable
    private final OnPageCommitVisibleCallback mPageCommitVisibleCallback;
    private final Activity mActivity;
    @VisibleForTesting
    public static ExpectedPage mExpectedPage = null;

    public Activity getActivity() {
        return this.mActivity;
    }

    IAuthorizationCompletionCallback getCompletionCallback() {
        return this.mCompletionCallback;
    }

    OAuth2WebViewClient(@NonNull Activity activity, @NonNull IAuthorizationCompletionCallback completionCallback, @NonNull OnPageLoadedCallback pageLoadedCallback) {
        this(activity, completionCallback, pageLoadedCallback, null);
    }

    OAuth2WebViewClient(@NonNull Activity activity, @NonNull IAuthorizationCompletionCallback completionCallback, @NonNull OnPageLoadedCallback pageLoadedCallback, @Nullable OnPageCommitVisibleCallback pageCommitVisibleCallback) {
        this.mActivity = activity;
        this.mCompletionCallback = completionCallback;
        this.mPageLoadedCallback = pageLoadedCallback;
        this.mPageCommitVisibleCallback = pageCommitVisibleCallback;
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        Logger.info(TAG, "Receive the http auth request. Start the dialog to ask for creds. ");
        Logger.infoPII(TAG, "Host:" + host);
        NtlmChallenge ntlmChallenge = ChallengeFactory.getNtlmChallenge(view, handler, host, realm);
        NtlmChallengeHandler challengeHandler = new NtlmChallengeHandler(this.mActivity, this.mCompletionCallback);
        challengeHandler.processChallenge(ntlmChallenge);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        this.sendErrorToCallback(view, errorCode, description);
    }

    @RequiresApi(api=23)
    public void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceError error) {
        this.sendErrorToCallback(view, error.getErrorCode(), error.getDescription().toString());
    }

    private void sendErrorToCallback(@NonNull WebView view, int errorCode, @NonNull String description) {
        view.stopLoading();
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Error Code:" + errorCode);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", description);
        this.mCompletionCallback.onChallengeResponseReceived(2002, resultIntent);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        super.onReceivedSslError(view, handler, error);
        handler.cancel();
        String errMsg = "Received SSL Error during request. For more info see: https://go.microsoft.com/fwlink/?linkid=2138180";
        Logger.error(TAG + ":onReceivedSslError", "Received SSL Error during request. For more info see: https://go.microsoft.com/fwlink/?linkid=2138180", null);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Code:-11");
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", error.toString());
        this.mCompletionCallback.onChallengeResponseReceived(2002, resultIntent);
    }

    public void onPageCommitVisible(WebView view, String url) {
        super.onPageCommitVisible(view, url);
        if (this.mPageCommitVisibleCallback != null) {
            this.mPageCommitVisibleCallback.onPageCommitVisible();
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.mPageLoadedCallback.onPageLoaded();
        if (mExpectedPage != null && url.startsWith(OAuth2WebViewClient.mExpectedPage.mExpectedPageUrlStartsWith)) {
            OAuth2WebViewClient.mExpectedPage.mCallback.onPageLoaded();
        }
        view.setVisibility(0);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.checkStartUrl(url);
        Logger.info(TAG, "WebView starts loading.");
        super.onPageStarted(view, url, favicon);
    }

    private void checkStartUrl(String url) {
        if (StringUtil.isEmpty(url)) {
            Logger.info(TAG, "onPageStarted: Null url for page to load.");
            return;
        }
        Uri uri = Uri.parse((String)url);
        if (uri.isOpaque()) {
            Logger.info(TAG, "onPageStarted: Non-hierarchical loading uri.");
            Logger.infoPII(TAG, "start url: " + url);
        } else if (StringUtil.isEmpty(uri.getQueryParameter("code"))) {
            Logger.info(TAG, "onPageStarted: URI has no auth code ('code') query parameter.");
            Logger.infoPII(TAG, "Scheme:" + uri.getScheme() + " Host: " + uri.getHost() + " Path: " + uri.getPath());
        } else {
            Logger.info(TAG, "Auth code is returned for the loading url.");
            Logger.infoPII(TAG, "Scheme:" + uri.getScheme() + " Host: " + uri.getHost() + " Path: " + uri.getPath());
        }
    }
}

