/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.events;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.telemetry.Properties;

public class BaseEvent
extends Properties {
    public BaseEvent() {
        this.occurs(System.currentTimeMillis());
        this.correlationId((String)DiagnosticContext.getRequestContext().get("correlation_id"));
    }

    @Override
    public Properties put(String key, String value) {
        return super.put(key, value);
    }

    @Override
    public Properties remove(String key) {
        return super.remove(key);
    }

    @Override
    public Properties remove(String key, String value) {
        return super.remove(key, value);
    }

    @Override
    public Properties put(Properties appendProperties) {
        return super.put(appendProperties);
    }

    public BaseEvent names(@NonNull String eventName) {
        this.put("Microsoft.MSAL.event_name", eventName);
        return this;
    }

    public BaseEvent types(@NonNull String eventType) {
        this.put("Microsoft.MSAL.event_type", eventType);
        return this;
    }

    public BaseEvent occurs(@Nullable Long eventStartTime) {
        if (null == eventStartTime) {
            this.put("Microsoft.MSAL.occur_time", String.valueOf(System.currentTimeMillis()));
        } else {
            this.put("Microsoft.MSAL.occur_time", eventStartTime.toString());
        }
        return this;
    }

    public BaseEvent correlationId(String correlationId) {
        this.put("Microsoft.MSAL.correlation_id", correlationId);
        return this;
    }
}

