/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.HttpClient;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.internal.platform.Device;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenRequest;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationErrorResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResult;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.oauth2.AccessToken;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Configuration;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.util.ClockSkewManager;
import com.microsoft.identity.common.internal.util.IClockSkewManager;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeMap;
import java.util.concurrent.Future;

public abstract class OAuth2Strategy<GenericAccessToken extends AccessToken, GenericAccount extends BaseAccount, GenericAuthorizationRequest extends AuthorizationRequest, GenericAuthorizationRequestBuilder extends AuthorizationRequest.Builder, GenericAuthorizationStrategy extends AuthorizationStrategy, GenericOAuth2Configuration extends OAuth2Configuration, GenericOAuth2StrategyParameters extends OAuth2StrategyParameters, GenericAuthorizationResponse extends AuthorizationResponse, GenericRefreshToken extends RefreshToken, GenericTokenRequest extends TokenRequest, GenericTokenResponse extends TokenResponse, GenericTokenResult extends TokenResult, GenericAuthorizationResult extends AuthorizationResult> {
    private static final String TAG = OAuth2Strategy.class.getSimpleName();
    protected static final String TOKEN_REQUEST_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected static final String DEVICE_CODE_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected final HttpClient httpClient = UrlConnectionHttpClient.getDefaultInstance();
    protected final GenericOAuth2Configuration mConfig;
    protected final GenericOAuth2StrategyParameters mStrategyParameters;
    protected final IClockSkewManager mClockSkewManager;
    protected String mTokenEndpoint;
    protected String mAuthorizationEndpoint;
    private Uri mIssuer;

    public OAuth2Strategy(GenericOAuth2Configuration config, GenericOAuth2StrategyParameters strategyParameters) {
        this.mConfig = config;
        this.mStrategyParameters = strategyParameters;
        if (null != ((OAuth2StrategyParameters)this.mStrategyParameters).getContext()) {
            this.mClockSkewManager = new ClockSkewManager(((OAuth2StrategyParameters)this.mStrategyParameters).getContext());
        } else {
            Logger.info(TAG, "No valid context to persist clock skew with!");
            this.mClockSkewManager = null;
        }
    }

    @NonNull
    public Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest request, GenericAuthorizationStrategy authorizationStrategy) throws ClientException {
        this.validateAuthorizationRequest(request);
        Future<AuthorizationResult> authorizationFuture = ((AuthorizationStrategy)authorizationStrategy).requestAuthorization(request, (OAuth2Strategy)this);
        return authorizationFuture;
    }

    public abstract AuthorizationResultFactory getAuthorizationResultFactory();

    public GenericTokenResult requestToken(GenericTokenRequest request) throws IOException, ClientException {
        String methodName = ":requestToken";
        Logger.verbose(TAG + ":requestToken", "Requesting token...");
        this.validateTokenRequest(request);
        HttpResponse response = this.performTokenRequest(request);
        GenericTokenResult result = this.getTokenResultFromHttpResponse(response);
        if (((TokenResult)result).getSuccess()) {
            this.validateTokenResponse(request, (GenericTokenResponse)result);
        }
        return result;
    }

    private void validateTokenResponse(GenericTokenRequest request, GenericTokenResult result) throws ClientException {
        this.validateTokenResponse(request, (GenericTokenResponse)((TokenResult)result).getSuccessResponse());
    }

    protected HttpResponse performTokenRequest(GenericTokenRequest request) throws IOException, ClientException {
        URL requestUrl;
        HttpResponse response;
        String methodName = ":performTokenRequest";
        Logger.verbose(TAG + ":performTokenRequest", "Performing token request...");
        String requestBody = ObjectMapper.serializeObjectToFormUrlEncoded(request);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("client-request-id", (String)DiagnosticContext.getRequestContext().get("correlation_id"));
        if (request instanceof MicrosoftTokenRequest && !TextUtils.isEmpty((CharSequence)((MicrosoftTokenRequest)request).getBrokerVersion())) {
            headers.put("x-client-brkrver", ((MicrosoftTokenRequest)request).getBrokerVersion());
        }
        headers.putAll(Device.getPlatformIdParameters());
        headers.put("x-client-SKU", (String)DiagnosticContext.getRequestContext().get("x-client-SKU"));
        headers.put("x-client-Ver", Device.getProductVersion());
        headers.putAll(EstsTelemetry.getInstance().getTelemetryHeaders());
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        if (request instanceof MicrosoftTokenRequest) {
            headers.put("x-app-name", ((MicrosoftTokenRequest)request).getClientAppName());
            headers.put("x-app-ver", ((MicrosoftTokenRequest)request).getClientAppVersion());
        }
        if (null != (response = this.httpClient.post(requestUrl = new URL(this.mTokenEndpoint), headers, requestBody.getBytes("UTF-8"))).getDate()) {
            this.recordClockSkew(response.getDate().getTime());
        }
        return response;
    }

    private void recordClockSkew(long referenceTimeMillis) {
        if (null != this.mClockSkewManager) {
            this.mClockSkewManager.onTimestampReceived(referenceTimeMillis);
        }
    }

    protected final void setTokenEndpoint(String tokenEndpoint) {
        MicrosoftStsOAuth2Configuration oauth2Config;
        AzureActiveDirectorySlice slice;
        this.mTokenEndpoint = tokenEndpoint;
        if (this.mConfig != null && this.mConfig instanceof MicrosoftStsOAuth2Configuration && (slice = (oauth2Config = (MicrosoftStsOAuth2Configuration)this.mConfig).getSlice()) != null) {
            Uri.Builder uriBuilder = Uri.parse((String)this.mTokenEndpoint).buildUpon();
            if (!TextUtils.isEmpty((CharSequence)slice.getSlice())) {
                uriBuilder.appendQueryParameter("slice", slice.getSlice());
            }
            if (!TextUtils.isEmpty((CharSequence)slice.getDC())) {
                uriBuilder.appendQueryParameter("dc", slice.getDC());
            }
            this.mTokenEndpoint = uriBuilder.build().toString();
        }
    }

    public String getAuthorityFromTokenEndpoint() {
        return this.mTokenEndpoint.toLowerCase(Locale.ROOT).replace("oauth2/v2.0/token", "");
    }

    protected final void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.mAuthorizationEndpoint = authorizationEndpoint;
    }

    public AuthorizationResult getDeviceCode(@NonNull MicrosoftStsAuthorizationRequest authorizationRequest) throws IOException {
        String methodName = ":getDeviceCode";
        String requestBody = ObjectMapper.serializeObjectToFormUrlEncoded(authorizationRequest);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("client-request-id", (String)DiagnosticContext.getRequestContext().get("correlation_id"));
        headers.putAll(EstsTelemetry.getInstance().getTelemetryHeaders());
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        HttpResponse response = this.httpClient.post(((MicrosoftStsOAuth2Configuration)this.mConfig).getDeviceAuthorizationEndpoint(), headers, requestBody.getBytes("UTF-8"));
        if (response.getStatusCode() < 300) {
            HashMap parsedResponseBody = (HashMap)new Gson().fromJson(response.getBody(), new TypeToken<HashMap<String, String>>(){}.getType());
            MicrosoftStsAuthorizationResponse authorizationResponse = new MicrosoftStsAuthorizationResponse(null, authorizationRequest.getState(), parsedResponseBody);
            MicrosoftStsAuthorizationResult authorizationResult = new MicrosoftStsAuthorizationResult(AuthorizationStatus.SUCCESS, authorizationResponse);
            Logger.verbose(TAG + ":getDeviceCode", "Device Code Flow authorization successful...");
            return authorizationResult;
        }
        HashMap parsedResponseBody = (HashMap)new Gson().fromJson(response.getBody(), new TypeToken<HashMap<String, Object>>(){}.getType());
        MicrosoftStsAuthorizationErrorResponse authorizationErrorResponse = new MicrosoftStsAuthorizationErrorResponse((String)parsedResponseBody.get("error"), (String)parsedResponseBody.get("error_description"));
        MicrosoftStsAuthorizationResult authorizationResult = new MicrosoftStsAuthorizationResult(AuthorizationStatus.FAIL, authorizationErrorResponse);
        Logger.verbose(TAG + ":getDeviceCode", "Device Code Flow authorization failure...");
        return authorizationResult;
    }

    protected GenericOAuth2Configuration getOAuth2Configuration() {
        return this.mConfig;
    }

    protected Uri getIssuer() {
        return this.mIssuer;
    }

    protected final void setIssuer(Uri issuer) {
        this.mIssuer = issuer;
    }

    public abstract String getIssuerCacheIdentifier(GenericAuthorizationRequest var1);

    public abstract GenericAccessToken getAccessTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericRefreshToken getRefreshTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericAccount createAccount(GenericTokenResponse var1);

    public abstract GenericAuthorizationRequestBuilder createAuthorizationRequestBuilder();

    public abstract GenericAuthorizationRequestBuilder createAuthorizationRequestBuilder(IAccountRecord var1);

    public abstract GenericTokenRequest createTokenRequest(GenericAuthorizationRequest var1, GenericAuthorizationResponse var2, AbstractAuthenticationScheme var3) throws ClientException;

    public abstract GenericTokenRequest createRefreshTokenRequest(AbstractAuthenticationScheme var1) throws ClientException;

    protected abstract void validateAuthorizationRequest(GenericAuthorizationRequest var1);

    protected abstract void validateTokenRequest(GenericTokenRequest var1);

    protected abstract GenericTokenResult getTokenResultFromHttpResponse(HttpResponse var1) throws ClientException;

    protected abstract void validateTokenResponse(GenericTokenRequest var1, GenericTokenResponse var2) throws ClientException;

    public boolean validateCachedResult(@NonNull AbstractAuthenticationScheme authScheme, @NonNull ICacheRecord cacheRecord) {
        return true;
    }
}

