/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.eststelemetry.CurrentRequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.IRequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.LastRequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.SchemaConstants;
import com.microsoft.identity.common.internal.eststelemetry.TelemetryUtils;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class RequestTelemetry
implements IRequestTelemetry {
    private static final String TAG = RequestTelemetry.class.getSimpleName();
    @SerializedName(value="schema_version")
    private String mSchemaVersion;
    @SerializedName(value="platform_telemetry")
    private ConcurrentMap<String, String> mPlatformTelemetry;

    RequestTelemetry(@NonNull String schemaVersion) {
        this.mSchemaVersion = schemaVersion;
        this.mPlatformTelemetry = new ConcurrentHashMap<String, String>();
    }

    private boolean isPlatformTelemetryField(String key) {
        if (this instanceof CurrentRequestTelemetry) {
            return SchemaConstants.isCurrentPlatformField(key);
        }
        if (this instanceof LastRequestTelemetry) {
            return SchemaConstants.isLastPlatformField(key);
        }
        return false;
    }

    final void putInPlatformTelemetry(String key, String value) {
        if (this.isPlatformTelemetryField(key)) {
            this.mPlatformTelemetry.putIfAbsent(key, value);
        }
    }

    String getSchemaVersion() {
        return this.mSchemaVersion;
    }

    @Override
    public String getCompleteHeaderString() {
        String methodName = ":getCompleteHeaderString";
        if (StringUtil.isEmpty(this.mSchemaVersion)) {
            Logger.verbose(TAG + ":getCompleteHeaderString", "SCHEMA_VERSION is null or empty. Telemetry Header String cannot be formed.");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.mSchemaVersion).append("|").append(this.getHeaderStringForFields()).append("|").append(this.getPlatformTelemetryHeaderString());
        return sb.toString();
    }

    private String getPlatformTelemetryHeaderString() {
        String[] platformFields = this instanceof CurrentRequestTelemetry ? SchemaConstants.getCurrentRequestPlatformFields() : SchemaConstants.getLastRequestPlatformFields();
        return this.getHeaderStringForFields(platformFields, this.mPlatformTelemetry);
    }

    @NonNull
    private String getHeaderStringForFields(@Nullable String[] fields, @Nullable Map<String, String> telemetry) {
        if (fields == null || telemetry == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            String key = fields[i];
            String value = telemetry.get(key);
            String compliantValueString = TelemetryUtils.getSchemaCompliantString(value);
            sb.append(compliantValueString);
            if (i == fields.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    @Override
    public RequestTelemetry copySharedValues(@NonNull RequestTelemetry requestTelemetry) {
        for (Map.Entry entry : this.mPlatformTelemetry.entrySet()) {
            this.putInPlatformTelemetry((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }
}

