/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands.parameters;

import android.content.Context;
import com.google.gson.annotations.Expose;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.request.SdkType;

public class CommandParameters {
    private transient Context androidApplicationContext;
    private transient OAuth2TokenCache oAuth2TokenCache;
    private transient boolean isSharedDevice;
    @Expose
    private String applicationName;
    @Expose
    private String applicationVersion;
    @Expose
    private String requiredBrokerProtocolVersion;
    @Expose
    private SdkType sdkType;
    @Expose
    private String sdkVersion;
    @Expose
    private String clientId;
    @Expose
    private String redirectUri;
    @Expose
    private boolean powerOptCheckEnabled;
    @Expose
    private String correlationId;

    private static SdkType $default$sdkType() {
        return SdkType.MSAL;
    }

    protected CommandParameters(CommandParametersBuilder<?, ?> b) {
        this.androidApplicationContext = ((CommandParametersBuilder)b).androidApplicationContext;
        this.oAuth2TokenCache = ((CommandParametersBuilder)b).oAuth2TokenCache;
        this.isSharedDevice = ((CommandParametersBuilder)b).isSharedDevice;
        this.applicationName = ((CommandParametersBuilder)b).applicationName;
        this.applicationVersion = ((CommandParametersBuilder)b).applicationVersion;
        this.requiredBrokerProtocolVersion = ((CommandParametersBuilder)b).requiredBrokerProtocolVersion;
        this.sdkType = ((CommandParametersBuilder)b).sdkType$set ? ((CommandParametersBuilder)b).sdkType$value : CommandParameters.$default$sdkType();
        this.sdkVersion = ((CommandParametersBuilder)b).sdkVersion;
        this.clientId = ((CommandParametersBuilder)b).clientId;
        this.redirectUri = ((CommandParametersBuilder)b).redirectUri;
        this.powerOptCheckEnabled = ((CommandParametersBuilder)b).powerOptCheckEnabled;
        this.correlationId = ((CommandParametersBuilder)b).correlationId;
    }

    public static CommandParametersBuilder<?, ?> builder() {
        return new CommandParametersBuilderImpl();
    }

    public CommandParametersBuilder<?, ?> toBuilder() {
        return new CommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    public Context getAndroidApplicationContext() {
        return this.androidApplicationContext;
    }

    public OAuth2TokenCache getOAuth2TokenCache() {
        return this.oAuth2TokenCache;
    }

    public boolean isSharedDevice() {
        return this.isSharedDevice;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getRequiredBrokerProtocolVersion() {
        return this.requiredBrokerProtocolVersion;
    }

    public SdkType getSdkType() {
        return this.sdkType;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public boolean isPowerOptCheckEnabled() {
        return this.powerOptCheckEnabled;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandParameters)) {
            return false;
        }
        CommandParameters other = (CommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$applicationVersion = this.getApplicationVersion();
        String other$applicationVersion = other.getApplicationVersion();
        if (this$applicationVersion == null ? other$applicationVersion != null : !this$applicationVersion.equals(other$applicationVersion)) {
            return false;
        }
        String this$requiredBrokerProtocolVersion = this.getRequiredBrokerProtocolVersion();
        String other$requiredBrokerProtocolVersion = other.getRequiredBrokerProtocolVersion();
        if (this$requiredBrokerProtocolVersion == null ? other$requiredBrokerProtocolVersion != null : !this$requiredBrokerProtocolVersion.equals(other$requiredBrokerProtocolVersion)) {
            return false;
        }
        SdkType this$sdkType = this.getSdkType();
        SdkType other$sdkType = other.getSdkType();
        if (this$sdkType == null ? other$sdkType != null : !((Object)((Object)this$sdkType)).equals((Object)other$sdkType)) {
            return false;
        }
        String this$sdkVersion = this.getSdkVersion();
        String other$sdkVersion = other.getSdkVersion();
        if (this$sdkVersion == null ? other$sdkVersion != null : !this$sdkVersion.equals(other$sdkVersion)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
            return false;
        }
        return this.isPowerOptCheckEnabled() == other.isPowerOptCheckEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $applicationVersion = this.getApplicationVersion();
        result = result * 59 + ($applicationVersion == null ? 43 : $applicationVersion.hashCode());
        String $requiredBrokerProtocolVersion = this.getRequiredBrokerProtocolVersion();
        result = result * 59 + ($requiredBrokerProtocolVersion == null ? 43 : $requiredBrokerProtocolVersion.hashCode());
        SdkType $sdkType = this.getSdkType();
        result = result * 59 + ($sdkType == null ? 43 : ((Object)((Object)$sdkType)).hashCode());
        String $sdkVersion = this.getSdkVersion();
        result = result * 59 + ($sdkVersion == null ? 43 : $sdkVersion.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        result = result * 59 + (this.isPowerOptCheckEnabled() ? 79 : 97);
        return result;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    private static final class CommandParametersBuilderImpl
    extends CommandParametersBuilder<CommandParameters, CommandParametersBuilderImpl> {
        private CommandParametersBuilderImpl() {
        }

        @Override
        protected CommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public CommandParameters build() {
            return new CommandParameters(this);
        }
    }

    public static abstract class CommandParametersBuilder<C extends CommandParameters, B extends CommandParametersBuilder<C, B>> {
        private Context androidApplicationContext;
        private OAuth2TokenCache oAuth2TokenCache;
        private boolean isSharedDevice;
        private String applicationName;
        private String applicationVersion;
        private String requiredBrokerProtocolVersion;
        private boolean sdkType$set;
        private SdkType sdkType$value;
        private String sdkVersion;
        private String clientId;
        private String redirectUri;
        private boolean powerOptCheckEnabled;
        private String correlationId;

        protected B $fillValuesFrom(C instance) {
            CommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CommandParameters instance, CommandParametersBuilder<?, ?> b) {
            b.androidApplicationContext(instance.androidApplicationContext);
            b.oAuth2TokenCache(instance.oAuth2TokenCache);
            b.isSharedDevice(instance.isSharedDevice);
            b.applicationName(instance.applicationName);
            b.applicationVersion(instance.applicationVersion);
            b.requiredBrokerProtocolVersion(instance.requiredBrokerProtocolVersion);
            b.sdkType(instance.sdkType);
            b.sdkVersion(instance.sdkVersion);
            b.clientId(instance.clientId);
            b.redirectUri(instance.redirectUri);
            b.powerOptCheckEnabled(instance.powerOptCheckEnabled);
            b.correlationId(instance.correlationId);
        }

        protected abstract B self();

        public abstract C build();

        public B androidApplicationContext(Context androidApplicationContext) {
            this.androidApplicationContext = androidApplicationContext;
            return this.self();
        }

        public B oAuth2TokenCache(OAuth2TokenCache oAuth2TokenCache) {
            this.oAuth2TokenCache = oAuth2TokenCache;
            return this.self();
        }

        public B isSharedDevice(boolean isSharedDevice) {
            this.isSharedDevice = isSharedDevice;
            return this.self();
        }

        public B applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this.self();
        }

        public B applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this.self();
        }

        public B requiredBrokerProtocolVersion(String requiredBrokerProtocolVersion) {
            this.requiredBrokerProtocolVersion = requiredBrokerProtocolVersion;
            return this.self();
        }

        public B sdkType(SdkType sdkType) {
            this.sdkType$value = sdkType;
            this.sdkType$set = true;
            return this.self();
        }

        public B sdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this.self();
        }

        public B clientId(String clientId) {
            this.clientId = clientId;
            return this.self();
        }

        public B redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this.self();
        }

        public B powerOptCheckEnabled(boolean powerOptCheckEnabled) {
            this.powerOptCheckEnabled = powerOptCheckEnabled;
            return this.self();
        }

        public B correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this.self();
        }

        public String toString() {
            return "CommandParameters.CommandParametersBuilder(androidApplicationContext=" + this.androidApplicationContext + ", oAuth2TokenCache=" + this.oAuth2TokenCache + ", isSharedDevice=" + this.isSharedDevice + ", applicationName=" + this.applicationName + ", applicationVersion=" + this.applicationVersion + ", requiredBrokerProtocolVersion=" + this.requiredBrokerProtocolVersion + ", sdkType$value=" + (Object)((Object)this.sdkType$value) + ", sdkVersion=" + this.sdkVersion + ", clientId=" + this.clientId + ", redirectUri=" + this.redirectUri + ", powerOptCheckEnabled=" + this.powerOptCheckEnabled + ", correlationId=" + this.correlationId + ")";
        }
    }
}

