/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.net;

import android.content.Context;
import android.os.Debug;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.adal.internal.net.DefaultConnectionService;
import com.microsoft.identity.common.adal.internal.net.HttpUrlConnectionFactory;
import com.microsoft.identity.common.adal.internal.net.HttpWebResponse;
import com.microsoft.identity.common.exception.ClientException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HttpWebRequest {
    static final String REQUEST_METHOD_POST = "POST";
    static final String REQUEST_METHOD_GET = "GET";
    private static final int DEBUG_SIMULATE_DELAY = 0;
    private static final int CONNECT_TIME_OUT = AuthenticationSettings.INSTANCE.getConnectTimeOut();
    private static final int READ_TIME_OUT = AuthenticationSettings.INSTANCE.getReadTimeOut();
    private final String mRequestMethod;
    private final URL mUrl;
    private final byte[] mRequestContent;
    private final String mRequestContentType;
    private final Map<String, String> mRequestHeaders;

    public HttpWebRequest(URL requestURL, String requestMethod, Map<String, String> headers) {
        this(requestURL, requestMethod, headers, null, null);
    }

    public HttpWebRequest(URL requestURL, String requestMethod, Map<String, String> headers, byte[] requestContent, String requestContentType) {
        this.mUrl = requestURL;
        this.mRequestMethod = requestMethod;
        this.mRequestHeaders = new HashMap<String, String>();
        if (this.mUrl != null) {
            this.mRequestHeaders.put("Host", this.mUrl.getAuthority());
        }
        this.mRequestHeaders.putAll(headers);
        this.mRequestContent = requestContent;
        this.mRequestContentType = requestContentType;
    }

    private HttpURLConnection setupConnection() throws IOException {
        if (this.mUrl == null) {
            throw new IllegalArgumentException("requestURL");
        }
        if (!this.mUrl.getProtocol().equalsIgnoreCase("http") && !this.mUrl.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("requestURL");
        }
        HttpURLConnection.setFollowRedirects(true);
        HttpURLConnection connection = HttpUrlConnectionFactory.createHttpUrlConnection(this.mUrl);
        connection.setConnectTimeout(CONNECT_TIME_OUT);
        connection.setRequestProperty("Connection", "close");
        Set<Map.Entry<String, String>> headerEntries = this.mRequestHeaders.entrySet();
        for (Map.Entry<String, String> entry : headerEntries) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setReadTimeout(READ_TIME_OUT);
        connection.setInstanceFollowRedirects(true);
        connection.setUseCaches(false);
        connection.setRequestMethod(this.mRequestMethod);
        connection.setDoInput(true);
        HttpWebRequest.setRequestBody(connection, this.mRequestContent, this.mRequestContentType);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpWebResponse send() throws IOException {
        HttpWebResponse response;
        HttpURLConnection connection = this.setupConnection();
        InputStream responseStream = null;
        try {
            block6: {
                try {
                    responseStream = connection.getInputStream();
                }
                catch (IOException ex) {
                    responseStream = connection.getErrorStream();
                    if (responseStream != null) break block6;
                    throw ex;
                }
            }
            int statusCode = connection.getResponseCode();
            String responseBody = HttpWebRequest.convertStreamToString(responseStream);
            if (Debug.isDebuggerConnected()) {
                // empty if block
            }
            response = new HttpWebResponse(statusCode, responseBody, connection.getHeaderFields());
        }
        finally {
            HttpWebRequest.safeCloseStream(responseStream);
        }
        return response;
    }

    public static void throwIfNetworkNotAvailable(Context context) throws ClientException {
        HttpWebRequest.throwIfNetworkNotAvailable(context, false);
    }

    public static void throwIfNetworkNotAvailable(Context context, boolean performPowerOptimizationCheck) throws ClientException {
        DefaultConnectionService connectionService = new DefaultConnectionService(context);
        if (performPowerOptimizationCheck && connectionService.isNetworkDisabledFromOptimizations()) {
            throw new ClientException("device_network_not_available_doze_mode", "Connection is not available to refresh token because power optimization is enabled. And the device is in doze mode or the app is standby");
        }
        if (!connectionService.isConnectionAvailable()) {
            throw new ClientException("device_network_not_available", "Connection is not available to refresh token");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRequestBody(HttpURLConnection connection, byte[] contentRequest, String requestContentType) throws IOException {
        if (null != contentRequest) {
            connection.setDoOutput(true);
            if (null != requestContentType && !requestContentType.isEmpty()) {
                connection.setRequestProperty("Content-Type", requestContentType);
            }
            connection.setRequestProperty("Content-Length", Integer.toString(contentRequest.length));
            connection.setFixedLengthStreamingMode(contentRequest.length);
            OutputStream out = null;
            try {
                out = connection.getOutputStream();
                out.write(contentRequest);
            }
            finally {
                HttpWebRequest.safeCloseStream(out);
            }
        }
    }

    private static void safeCloseStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

