/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.logging.Logger;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.jca.PivProvider;
import java.security.Provider;
import java.security.Security;

public class YubiKeyPivProviderManager {
    private static final String TAG = YubiKeyPivProviderManager.class.getSimpleName();
    protected static final String YUBIKEY_PROVIDER = "YKPiv";

    public static void addPivProvider(@NonNull ICertBasedAuthTelemetryHelper telemetryHelper, @NonNull Callback<Callback<Result<PivSession, Exception>>> pivProviderCallback) {
        String methodTag = TAG + ":addPivProvider";
        if (Security.getProvider(YUBIKEY_PROVIDER) != null) {
            Security.removeProvider(YUBIKEY_PROVIDER);
            telemetryHelper.setExistingPivProviderPresent(true);
            Logger.info(methodTag, "Existing PivProvider was present in Security static list.");
        } else {
            telemetryHelper.setExistingPivProviderPresent(false);
            Logger.info(methodTag, "Security static list does not have existing PivProvider.");
        }
        Security.insertProviderAt((Provider)new PivProvider(pivProviderCallback), 1);
        Logger.info(methodTag, "An instance of PivProvider was added to Security static list.");
    }

    public static void removePivProvider() {
        if (Security.getProvider(YUBIKEY_PROVIDER) == null) {
            return;
        }
        Security.removeProvider(YUBIKEY_PROVIDER);
        Logger.info(TAG, "An instance of PivProvider was removed from Security static list.");
    }
}

