/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.IBrokerValidator;
import com.microsoft.identity.common.internal.util.PackageUtils;
import com.microsoft.identity.common.logging.Logger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B|\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012'\u0010\b\u001a#\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\t\u0012<\u0010\u0010\u001a8\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0012\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u0011\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\b\u001a#\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RD\u0010\u0010\u001a8\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0016\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/microsoft/identity/common/internal/broker/BrokerValidator;", "Lcom/microsoft/identity/common/internal/broker/IBrokerValidator;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "allowedBrokerApps", "", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "getSigningCertificateForApp", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "packageName", "", "Ljava/security/cert/X509Certificate;", "validateSigningCertificate", "Lkotlin/Function2;", "expectedSigningCertificateSignature", "signingCertificates", "", "(Ljava/util/Set;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "expectedSigningCertificateThumbprint", "isSignedByKnownKeys", "", "brokerData", "isValidBrokerPackage", "verifySignature", "Companion", "common_distRelease"})
public class BrokerValidator
implements IBrokerValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<BrokerData> allowedBrokerApps;
    @NotNull
    private final Function1<String, List<X509Certificate>> getSigningCertificateForApp;
    @NotNull
    private final Function2<String, List<? extends X509Certificate>, Unit> validateSigningCertificate;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(BrokerValidator.class).getSimpleName();

    public BrokerValidator(final @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.allowedBrokerApps = BrokerData.Companion.getKnownBrokerApps();
        this.getSigningCertificateForApp = (Function1)new Function1<String, List<X509Certificate>>(){

            public final List<X509Certificate> invoke(@NotNull String packageName) {
                Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                List<X509Certificate> list = PackageUtils.readCertDataForApp(packageName, context);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readCertDataForApp(packageName, context)");
                return list;
            }
        };
        this.validateSigningCertificate = (Function2)new Function2<String, List<? extends X509Certificate>, Unit>((Object)Companion){

            public final void invoke(@NotNull String p0, @NotNull List<? extends X509Certificate> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((Companion)this.receiver).validateSigningCertificate(p0, p1);
            }
        };
    }

    public BrokerValidator(@NotNull Set<BrokerData> allowedBrokerApps, @NotNull Function1<? super String, ? extends List<? extends X509Certificate>> getSigningCertificateForApp, @NotNull Function2<? super String, ? super List<? extends X509Certificate>, Unit> validateSigningCertificate) {
        Intrinsics.checkNotNullParameter(allowedBrokerApps, (String)"allowedBrokerApps");
        Intrinsics.checkNotNullParameter(getSigningCertificateForApp, (String)"getSigningCertificateForApp");
        Intrinsics.checkNotNullParameter(validateSigningCertificate, (String)"validateSigningCertificate");
        this.allowedBrokerApps = allowedBrokerApps;
        this.getSigningCertificateForApp = getSigningCertificateForApp;
        this.validateSigningCertificate = validateSigningCertificate;
    }

    public boolean verifySignature(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.isValidBrokerPackage(packageName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValidBrokerPackage(@NotNull String packageName) {
        Object v0;
        String methodTag;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            methodTag = TAG + ":isValidBrokerPackage";
            Iterable $this$filter$iv = this.allowedBrokerApps;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BrokerData it = (BrokerData)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getPackageName(), (String)packageName, (boolean)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BrokerData it = (BrokerData)element$iv;
                boolean bl = false;
                if (!this.isSignedByKnownKeys(it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        BrokerData matchingApp = v0;
        if (matchingApp != null) {
            return true;
        }
        Logger.info(methodTag, packageName + " does not match with any known broker apps.");
        return false;
    }

    @Override
    public boolean isSignedByKnownKeys(@NotNull BrokerData brokerData) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)brokerData, (String)"brokerData");
        String methodTag = TAG + ":isSignedByKnownKeys";
        try {
            List signingCertificate = (List)this.getSigningCertificateForApp.invoke((Object)brokerData.getPackageName());
            this.validateSigningCertificate.invoke((Object)brokerData.getSigningCertificateThumbprint(), (Object)signingCertificate);
            Logger.verbose(methodTag, brokerData + " is a valid broker app.");
            bl = true;
        }
        catch (Throwable t) {
            Logger.verbose(methodTag, brokerData + " verification failed: " + t.getMessage());
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/microsoft/identity/common/internal/broker/BrokerValidator$Companion;", "", "()V", "TAG", "", "validateSigningCertificate", "", "expectedSigningCertificateThumbprint", "signingCertificates", "", "Ljava/security/cert/X509Certificate;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final void validateSigningCertificate(@NotNull String expectedSigningCertificateThumbprint, @NotNull List<? extends X509Certificate> signingCertificates) {
            Intrinsics.checkNotNullParameter((Object)expectedSigningCertificateThumbprint, (String)"expectedSigningCertificateThumbprint");
            Intrinsics.checkNotNullParameter(signingCertificates, (String)"signingCertificates");
            PackageUtils.verifySignatureHash(signingCertificates, SetsKt.setOf((Object)expectedSigningCertificateThumbprint).iterator());
            if (signingCertificates.size() > 1) {
                PackageUtils.verifyCertificateChain(signingCertificates);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

