/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.os.Build;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.java.broker.IBrokerAccount;
import com.microsoft.identity.common.logging.Logger;
import lombok.NonNull;

public class AccountManagerBrokerAccount
implements IBrokerAccount {
    private static final String TAG = AccountManagerBrokerAccount.class.getSimpleName();
    @NonNull
    private final Account mAccount;

    @NonNull
    public String getUsername() {
        return this.mAccount.name;
    }

    @NonNull
    public String getType() {
        return this.mAccount.type;
    }

    @NonNull
    public static AccountManagerBrokerAccount cast(@NonNull AccountManager accountManager, @NonNull IBrokerAccount account) {
        if (accountManager == null) {
            throw new NullPointerException("accountManager is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (account instanceof AccountManagerBrokerAccount) {
            return (AccountManagerBrokerAccount)account;
        }
        return AccountManagerBrokerAccount.create(accountManager, account.getUsername(), account.getType());
    }

    @NonNull
    public static AccountManagerBrokerAccount adapt(@NonNull Account account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        return new AccountManagerBrokerAccount(account);
    }

    @NonNull
    public static AccountManagerBrokerAccount create(@NonNull AccountManager accountManager, @NonNull String accountName, @NonNull String accountType) {
        if (accountManager == null) {
            throw new NullPointerException("accountManager is marked non-null but is null");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName is marked non-null but is null");
        }
        if (accountType == null) {
            throw new NullPointerException("accountType is marked non-null but is null");
        }
        String methodTag = TAG + ":create";
        Account account = AccountManagerBrokerAccount.getAccount(accountManager, accountName, accountType);
        if (account == null) {
            account = new Account(accountName, accountType);
            Logger.verbose(methodTag, "Creating account.");
            Logger.verbosePII(methodTag, "Creating account with name :" + account.name);
            accountManager.addAccountExplicitly(account, null, null);
        }
        AccountManagerBrokerAccount.setVisibility(accountManager, account, "com.azure.authenticator");
        AccountManagerBrokerAccount.setVisibility(accountManager, account, "com.microsoft.windowsintune.companyportal");
        if (BrokerData.getShouldTrustDebugBrokers()) {
            AccountManagerBrokerAccount.setVisibility(accountManager, account, BrokerData.getDebugMockCp().getPackageName());
            AccountManagerBrokerAccount.setVisibility(accountManager, account, BrokerData.getDebugMockAuthApp().getPackageName());
            AccountManagerBrokerAccount.setVisibility(accountManager, account, BrokerData.getDebugBrokerHost().getPackageName());
        }
        return AccountManagerBrokerAccount.adapt(account);
    }

    private static void setVisibility(@NonNull AccountManager accountManager, @NonNull Account account, @NonNull String packageName) {
        if (accountManager == null) {
            throw new NullPointerException("accountManager is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (packageName == null) {
            throw new NullPointerException("packageName is marked non-null but is null");
        }
        if (Build.VERSION.SDK_INT >= 26 && accountManager.getAccountVisibility(account, packageName) != 1) {
            accountManager.setAccountVisibility(account, packageName, 1);
        }
    }

    @Nullable
    private static Account getAccount(@NonNull AccountManager accountManager, @NonNull String accountName, @NonNull String accountType) {
        if (accountManager == null) {
            throw new NullPointerException("accountManager is marked non-null but is null");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName is marked non-null but is null");
        }
        if (accountType == null) {
            throw new NullPointerException("accountType is marked non-null but is null");
        }
        String methodTag = TAG + ":getAccount";
        Account[] accountList = accountManager.getAccountsByType(accountType);
        if (accountList != null) {
            for (Account existingAcct : accountList) {
                if (!existingAcct.name.equalsIgnoreCase(accountName)) continue;
                return existingAcct;
            }
        }
        Logger.verbose(methodTag, "Account not found.");
        return null;
    }

    @NonNull
    public Account getAccount() {
        return this.mAccount;
    }

    private AccountManagerBrokerAccount(@NonNull Account account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        this.mAccount = account;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountManagerBrokerAccount)) {
            return false;
        }
        AccountManagerBrokerAccount other = (AccountManagerBrokerAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Account this$mAccount = this.getAccount();
        Account other$mAccount = other.getAccount();
        return !(this$mAccount == null ? other$mAccount != null : !this$mAccount.equals(other$mAccount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountManagerBrokerAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Account $mAccount = this.getAccount();
        result = result * 59 + ($mAccount == null ? 43 : $mAccount.hashCode());
        return result;
    }
}

