/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class AuthenticationResult
implements IAuthenticationResult {
    private static final String TAG = AuthenticationResult.class.getSimpleName();
    private final String mTenantId;
    private final AccessTokenRecord mAccessToken;
    private final IAccount mAccount;
    private final UUID mCorrelationId;

    AuthenticationResult(@NonNull List<ICacheRecord> cacheRecords, @Nullable String correlationId) {
        ICacheRecord mostRecentlyAuthorized = cacheRecords.get(0);
        this.mAccessToken = mostRecentlyAuthorized.getAccessToken();
        this.mTenantId = mostRecentlyAuthorized.getAccount().getRealm();
        this.mAccount = AccountAdapter.adapt(cacheRecords).get(0);
        this.mCorrelationId = this.sanitizeCorrelationId(correlationId);
    }

    @Override
    @NonNull
    public String getAccessToken() {
        return this.mAccessToken.getSecret();
    }

    @Override
    @NonNull
    public String getAuthorizationHeader() {
        String scheme = this.mAccessToken.getAccessTokenType();
        return scheme + " " + this.mAccessToken.getSecret();
    }

    @Override
    @NonNull
    public String getAuthenticationScheme() {
        return this.mAccessToken.getAccessTokenType();
    }

    @Override
    @NonNull
    public Date getExpiresOn() {
        Date expiresOn = new Date(TimeUnit.SECONDS.toMillis(Long.parseLong(this.mAccessToken.getExpiresOn())));
        return expiresOn;
    }

    @Override
    @Nullable
    public String getTenantId() {
        return this.mTenantId;
    }

    @Override
    @NonNull
    public IAccount getAccount() {
        return this.mAccount;
    }

    @Override
    @NonNull
    public String[] getScope() {
        return this.mAccessToken.getTarget().split("\\s");
    }

    @Override
    @Nullable
    public UUID getCorrelationId() {
        return this.mCorrelationId;
    }

    @Nullable
    private UUID sanitizeCorrelationId(@Nullable String correlationId) {
        String methodName = "sanitizeCorrelationId";
        if (TextUtils.isEmpty((CharSequence)correlationId)) {
            Logger.warn((String)(TAG + "sanitizeCorrelationId"), (String)"Correlation id was empty, returning null.");
            return null;
        }
        try {
            return UUID.fromString(correlationId);
        }
        catch (IllegalArgumentException e) {
            Logger.error((String)(TAG + "sanitizeCorrelationId"), (String)"Correlation id is not a valid UUID.", (Throwable)e);
            return null;
        }
    }
}

