/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.ClientInfo;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.util.AccountUtil;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.util.Map;

public class Account
implements IAccount {
    private static final String TAG = Account.class.getSimpleName();
    private final Map<String, ?> mIdTokenClaims;
    private final String mRawIdToken;
    private String mClientInfo;
    private String mHomeOid;
    private String mHomeTenantId;
    private String mEnvironment;
    private String mHomeAccountId;

    public Account(@Nullable String clientInfo, @Nullable IDToken homeTenantIdToken) {
        this.mClientInfo = clientInfo;
        if (null != homeTenantIdToken) {
            this.mIdTokenClaims = homeTenantIdToken.getTokenClaims();
            this.mRawIdToken = homeTenantIdToken.getRawIDToken();
        } else {
            this.mIdTokenClaims = null;
            this.mRawIdToken = null;
        }
    }

    void setId(@Nullable String id2) {
        this.mHomeOid = id2;
    }

    @Override
    @NonNull
    public String getId() {
        String id2;
        String methodName = ":getId";
        ClientInfo clientInfo = null;
        if (null != this.mClientInfo) {
            try {
                clientInfo = new ClientInfo(this.mClientInfo);
            }
            catch (MsalClientException e) {
                com.microsoft.identity.common.internal.logging.Logger.error((String)TAG, (String)"Failed to parse ClientInfo", (Throwable)((Object)e));
            }
        }
        if (StringUtil.isEmpty((String)(id2 = null != clientInfo ? clientInfo.getUniqueIdentifier() : (null != this.mIdTokenClaims ? (String)this.mIdTokenClaims.get("oid") : this.mHomeOid)))) {
            Logger.warn((String)(TAG + ":getId"), (String)"Unable to get account id from either ClientInfo or IdToken. Attempting to obtain from home account id.");
            id2 = AccountUtil.getUIdFromHomeAccountId((String)this.mHomeAccountId);
        }
        if (StringUtil.isEmpty((String)id2)) {
            Logger.error((String)(TAG + ":getId"), (String)"Account ID is empty. Returning MISSING_FROM_THE_TOKEN_RESPONSE.", null);
            id2 = "Missing from the token response";
        }
        return id2;
    }

    void setTenantId(@NonNull String tenantId) {
        this.mHomeTenantId = tenantId;
    }

    @Override
    @NonNull
    public String getTenantId() {
        return this.mHomeTenantId;
    }

    @NonNull
    String getHomeAccountId() {
        return this.getId() + "." + this.mHomeTenantId;
    }

    void setEnvironment(@NonNull String environment) {
        this.mEnvironment = environment;
    }

    @NonNull
    String getEnvironment() {
        return this.mEnvironment;
    }

    @Override
    @Nullable
    public String getIdToken() {
        return this.mRawIdToken;
    }

    @Override
    @Nullable
    public Map<String, ?> getClaims() {
        return this.mIdTokenClaims;
    }

    @Override
    @NonNull
    public String getUsername() {
        if (null != this.getClaims()) {
            return SchemaUtil.getDisplayableId(this.getClaims());
        }
        return "Missing from the token response";
    }

    @Override
    @NonNull
    public String getAuthority() {
        String iss;
        if (null != this.getClaims() && !StringUtil.isEmpty((String)(iss = (String)this.getClaims().get("iss")))) {
            return iss;
        }
        return "Missing from the token response";
    }

    public void setHomeAccountId(@NonNull String homeAccountId) {
        this.mHomeAccountId = homeAccountId;
    }
}

