/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IOutlookCategoryCollectionPage;
import com.microsoft.graph.extensions.IOutlookCategoryCollectionRequest;
import com.microsoft.graph.extensions.OutlookCategory;
import com.microsoft.graph.extensions.OutlookCategoryCollectionPage;
import com.microsoft.graph.extensions.OutlookCategoryCollectionRequest;
import com.microsoft.graph.extensions.OutlookCategoryCollectionRequestBuilder;
import com.microsoft.graph.extensions.OutlookCategoryRequestBuilder;
import com.microsoft.graph.generated.BaseOutlookCategoryCollectionResponse;
import com.microsoft.graph.generated.IBaseOutlookCategoryCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseOutlookCategoryCollectionRequest
extends BaseCollectionRequest<BaseOutlookCategoryCollectionResponse, IOutlookCategoryCollectionPage>
implements IBaseOutlookCategoryCollectionRequest {
    public BaseOutlookCategoryCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseOutlookCategoryCollectionResponse.class, IOutlookCategoryCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOutlookCategoryCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseOutlookCategoryCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOutlookCategoryCollectionPage get() throws ClientException {
        BaseOutlookCategoryCollectionResponse response = (BaseOutlookCategoryCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OutlookCategory newOutlookCategory, ICallback<OutlookCategory> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OutlookCategoryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOutlookCategory, callback);
    }

    @Override
    public OutlookCategory post(OutlookCategory newOutlookCategory) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OutlookCategoryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOutlookCategory);
    }

    @Override
    public IOutlookCategoryCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (OutlookCategoryCollectionRequest)this;
    }

    @Override
    public IOutlookCategoryCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (OutlookCategoryCollectionRequest)this;
    }

    @Override
    public IOutlookCategoryCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (OutlookCategoryCollectionRequest)this;
    }

    public IOutlookCategoryCollectionPage buildFromResponse(BaseOutlookCategoryCollectionResponse response) {
        OutlookCategoryCollectionRequestBuilder builder = response.nextLink != null ? new OutlookCategoryCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OutlookCategoryCollectionPage page = new OutlookCategoryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

