// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Data Labels Request.
 */
public interface IBaseWorkbookChartDataLabelsRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartDataLabels from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartDataLabels> callback);

    /**
     * Gets the WorkbookChartDataLabels from the service
     * @return The WorkbookChartDataLabels from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartDataLabels get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartDataLabels with a source
     * @param sourceWorkbookChartDataLabels The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartDataLabels sourceWorkbookChartDataLabels, final ICallback<WorkbookChartDataLabels> callback);

    /**
     * Patches this WorkbookChartDataLabels with a source
     * @param sourceWorkbookChartDataLabels The source object with updates
     * @return The updated WorkbookChartDataLabels
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartDataLabels patch(final WorkbookChartDataLabels sourceWorkbookChartDataLabels) throws ClientException;

    /**
     * Posts a WorkbookChartDataLabels with a new object
     * @param newWorkbookChartDataLabels The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartDataLabels newWorkbookChartDataLabels, final ICallback<WorkbookChartDataLabels> callback);

    /**
     * Posts a WorkbookChartDataLabels with a new object
     * @param newWorkbookChartDataLabels The new object to create
     * @return The created WorkbookChartDataLabels
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartDataLabels post(final WorkbookChartDataLabels newWorkbookChartDataLabels) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartDataLabelsRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartDataLabelsRequest expand(final String value);

}

