// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Message Rule Request.
 */
public interface IBaseMessageRuleRequest extends IHttpRequest {

    /**
     * Gets the MessageRule from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<MessageRule> callback);

    /**
     * Gets the MessageRule from the service
     * @return The MessageRule from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    MessageRule get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MessageRule with a source
     * @param sourceMessageRule The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final MessageRule sourceMessageRule, final ICallback<MessageRule> callback);

    /**
     * Patches this MessageRule with a source
     * @param sourceMessageRule The source object with updates
     * @return The updated MessageRule
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    MessageRule patch(final MessageRule sourceMessageRule) throws ClientException;

    /**
     * Posts a MessageRule with a new object
     * @param newMessageRule The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final MessageRule newMessageRule, final ICallback<MessageRule> callback);

    /**
     * Posts a MessageRule with a new object
     * @param newMessageRule The new object to create
     * @return The created MessageRule
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    MessageRule post(final MessageRule newMessageRule) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseMessageRuleRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseMessageRuleRequest expand(final String value);

}

