// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Binom_Dist_Range Request Builder.
 */
public class BaseWorkbookFunctionsBinom_Dist_RangeRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsBinom_Dist_Range
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsBinom_Dist_RangeRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement trials, final com.google.gson.JsonElement probabilityS, final com.google.gson.JsonElement numberS, final com.google.gson.JsonElement numberS2) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("trials", trials);
        mBodyParams.put("probabilityS", probabilityS);
        mBodyParams.put("numberS", numberS);
        mBodyParams.put("numberS2", numberS2);
    }

    /**
     * Creates the IWorkbookFunctionsBinom_Dist_RangeRequest
     *
     * @return The IWorkbookFunctionsBinom_Dist_RangeRequest instance
     */
    public IWorkbookFunctionsBinom_Dist_RangeRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsBinom_Dist_RangeRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsBinom_Dist_RangeRequest instance
     */
    public IWorkbookFunctionsBinom_Dist_RangeRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsBinom_Dist_RangeRequest request = new WorkbookFunctionsBinom_Dist_RangeRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("trials")) {
            request.mBody.trials = getParameter("trials");
        }

        if (hasParameter("probabilityS")) {
            request.mBody.probabilityS = getParameter("probabilityS");
        }

        if (hasParameter("numberS")) {
            request.mBody.numberS = getParameter("numberS");
        }

        if (hasParameter("numberS2")) {
            request.mBody.numberS2 = getParameter("numberS2");
        }

        return request;
    }
}
