// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base User Activity.
 */
public class BaseUserActivity extends Entity implements IJsonBackedObject {


    /**
     * The Visual Elements.
     * 
     */
    @SerializedName("visualElements")
    @Expose
    public VisualInfo visualElements;

    /**
     * The Activity Source Host.
     * 
     */
    @SerializedName("activitySourceHost")
    @Expose
    public String activitySourceHost;

    /**
     * The Activation Url.
     * 
     */
    @SerializedName("activationUrl")
    @Expose
    public String activationUrl;

    /**
     * The App Activity Id.
     * 
     */
    @SerializedName("appActivityId")
    @Expose
    public String appActivityId;

    /**
     * The App Display Name.
     * 
     */
    @SerializedName("appDisplayName")
    @Expose
    public String appDisplayName;

    /**
     * The Content Url.
     * 
     */
    @SerializedName("contentUrl")
    @Expose
    public String contentUrl;

    /**
     * The Created Date Time.
     * 
     */
    @SerializedName("createdDateTime")
    @Expose
    public java.util.Calendar createdDateTime;

    /**
     * The Expiration Date Time.
     * 
     */
    @SerializedName("expirationDateTime")
    @Expose
    public java.util.Calendar expirationDateTime;

    /**
     * The Fallback Url.
     * 
     */
    @SerializedName("fallbackUrl")
    @Expose
    public String fallbackUrl;

    /**
     * The Last Modified Date Time.
     * 
     */
    @SerializedName("lastModifiedDateTime")
    @Expose
    public java.util.Calendar lastModifiedDateTime;

    /**
     * The User Timezone.
     * 
     */
    @SerializedName("userTimezone")
    @Expose
    public String userTimezone;

    /**
     * The Content Info.
     * 
     */
    @SerializedName("contentInfo")
    @Expose
    public com.google.gson.JsonElement contentInfo;

    /**
     * The Status.
     * 
     */
    @SerializedName("status")
    @Expose
    public Status status;

    /**
     * The History Items.
     * 
     */
    public transient ActivityHistoryItemCollectionPage historyItems;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;


        if (json.has("historyItems")) {
            final BaseActivityHistoryItemCollectionResponse response = new BaseActivityHistoryItemCollectionResponse();
            if (json.has("historyItems@odata.nextLink")) {
                response.nextLink = json.get("historyItems@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("historyItems").toString(), JsonObject[].class);
            final ActivityHistoryItem[] array = new ActivityHistoryItem[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), ActivityHistoryItem.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            historyItems = new ActivityHistoryItemCollectionPage(response, null);
        }
    }
}
