// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Notebook Copy Notebook Request Builder.
 */
public class BaseNotebookCopyNotebookRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this NotebookCopyNotebook
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseNotebookCopyNotebookRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final String groupId, final String renameAs, final String notebookFolder, final String siteCollectionId, final String siteId) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("groupId", groupId);
        mBodyParams.put("renameAs", renameAs);
        mBodyParams.put("notebookFolder", notebookFolder);
        mBodyParams.put("siteCollectionId", siteCollectionId);
        mBodyParams.put("siteId", siteId);
    }

    /**
     * Creates the INotebookCopyNotebookRequest
     *
     * @return The INotebookCopyNotebookRequest instance
     */
    public INotebookCopyNotebookRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the INotebookCopyNotebookRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The INotebookCopyNotebookRequest instance
     */
    public INotebookCopyNotebookRequest buildRequest(final java.util.List<Option> requestOptions) {
        NotebookCopyNotebookRequest request = new NotebookCopyNotebookRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("groupId")) {
            request.mBody.groupId = getParameter("groupId");
        }

        if (hasParameter("renameAs")) {
            request.mBody.renameAs = getParameter("renameAs");
        }

        if (hasParameter("notebookFolder")) {
            request.mBody.notebookFolder = getParameter("notebookFolder");
        }

        if (hasParameter("siteCollectionId")) {
            request.mBody.siteCollectionId = getParameter("siteCollectionId");
        }

        if (hasParameter("siteId")) {
            request.mBody.siteId = getParameter("siteId");
        }

        return request;
    }
}
