// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base List Item Version Collection Request.
 */
public class BaseListItemVersionCollectionRequest extends BaseCollectionRequest<BaseListItemVersionCollectionResponse, IListItemVersionCollectionPage> implements IBaseListItemVersionCollectionRequest {

    /**
     * The request builder for this collection of ListItemVersion
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseListItemVersionCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseListItemVersionCollectionResponse.class, IListItemVersionCollectionPage.class);
    }

    public void get(final ICallback<IListItemVersionCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IListItemVersionCollectionPage get() throws ClientException {
        final BaseListItemVersionCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ListItemVersion newListItemVersion, final ICallback<ListItemVersion> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ListItemVersionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newListItemVersion, callback);
    }

    public ListItemVersion post(final ListItemVersion newListItemVersion) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ListItemVersionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newListItemVersion);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IListItemVersionCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ListItemVersionCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IListItemVersionCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ListItemVersionCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IListItemVersionCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ListItemVersionCollectionRequest)this;
    }

    public IListItemVersionCollectionPage buildFromResponse(final BaseListItemVersionCollectionResponse response) {
        final IListItemVersionCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ListItemVersionCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ListItemVersionCollectionPage page = new ListItemVersionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
