// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Group Lifecycle Policy Remove Group Request Builder.
 */
public class BaseGroupLifecyclePolicyRemoveGroupRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this GroupLifecyclePolicyRemoveGroup
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseGroupLifecyclePolicyRemoveGroupRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final String groupId) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("groupId", groupId);
    }

    /**
     * Creates the IGroupLifecyclePolicyRemoveGroupRequest
     *
     * @return The IGroupLifecyclePolicyRemoveGroupRequest instance
     */
    public IGroupLifecyclePolicyRemoveGroupRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IGroupLifecyclePolicyRemoveGroupRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IGroupLifecyclePolicyRemoveGroupRequest instance
     */
    public IGroupLifecyclePolicyRemoveGroupRequest buildRequest(final java.util.List<Option> requestOptions) {
        GroupLifecyclePolicyRemoveGroupRequest request = new GroupLifecyclePolicyRemoveGroupRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("groupId")) {
            request.mBody.groupId = getParameter("groupId");
        }

        return request;
    }
}
