// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education Class Collection Request.
 */
public class BaseEducationClassCollectionRequest extends BaseCollectionRequest<BaseEducationClassCollectionResponse, IEducationClassCollectionPage> implements IBaseEducationClassCollectionRequest {

    /**
     * The request builder for this collection of EducationClass
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseEducationClassCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEducationClassCollectionResponse.class, IEducationClassCollectionPage.class);
    }

    public void get(final ICallback<IEducationClassCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IEducationClassCollectionPage get() throws ClientException {
        final BaseEducationClassCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final EducationClass newEducationClass, final ICallback<EducationClass> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new EducationClassRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newEducationClass, callback);
    }

    public EducationClass post(final EducationClass newEducationClass) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new EducationClassRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newEducationClass);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IEducationClassCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (EducationClassCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IEducationClassCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (EducationClassCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IEducationClassCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (EducationClassCollectionRequest)this;
    }

    public IEducationClassCollectionPage buildFromResponse(final BaseEducationClassCollectionResponse response) {
        final IEducationClassCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new EducationClassCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final EducationClassCollectionPage page = new EducationClassCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
