// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Drive Item Version Restore Version Request Builder.
 */
public class BaseDriveItemVersionRestoreVersionRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this DriveItemVersionRestoreVersion
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseDriveItemVersionRestoreVersionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IDriveItemVersionRestoreVersionRequest
     *
     * @return The IDriveItemVersionRestoreVersionRequest instance
     */
    public IDriveItemVersionRestoreVersionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IDriveItemVersionRestoreVersionRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IDriveItemVersionRestoreVersionRequest instance
     */
    public IDriveItemVersionRestoreVersionRequest buildRequest(final java.util.List<Option> requestOptions) {
        DriveItemVersionRestoreVersionRequest request = new DriveItemVersionRestoreVersionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
