// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Drive Item Version Request.
 */
public class BaseDriveItemVersionRequest extends BaseRequest implements IBaseDriveItemVersionRequest {

    /**
     * The request for the DriveItemVersion
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseDriveItemVersionRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the DriveItemVersion from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<DriveItemVersion> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DriveItemVersion from the service
     * @return The DriveItemVersion from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DriveItemVersion get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this DriveItemVersion with a source
     * @param sourceDriveItemVersion The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final DriveItemVersion sourceDriveItemVersion, final ICallback<DriveItemVersion> callback) {
        send(HttpMethod.PATCH, callback, sourceDriveItemVersion);
    }

    /**
     * Patches this DriveItemVersion with a source
     * @param sourceDriveItemVersion The source object with updates
     * @return The updated DriveItemVersion
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DriveItemVersion patch(final DriveItemVersion sourceDriveItemVersion) throws ClientException {
        return send(HttpMethod.PATCH, sourceDriveItemVersion);
    }

    /**
     * Creates a DriveItemVersion with a new object
     * @param newDriveItemVersion The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final DriveItemVersion newDriveItemVersion, final ICallback<DriveItemVersion> callback) {
        send(HttpMethod.POST, callback, newDriveItemVersion);
    }

    /**
     * Creates a DriveItemVersion with a new object
     * @param newDriveItemVersion The new object to create
     * @return The created DriveItemVersion
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DriveItemVersion post(final DriveItemVersion newDriveItemVersion) throws ClientException {
        return send(HttpMethod.POST, newDriveItemVersion);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IDriveItemVersionRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (DriveItemVersionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IDriveItemVersionRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (DriveItemVersionRequest)this;
     }

}

