// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Administrative Unit With Reference Request.
 */
public class BaseAdministrativeUnitWithReferenceRequest extends BaseRequest implements IBaseAdministrativeUnitWithReferenceRequest {

    /**
     * The request for the AdministrativeUnit
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseAdministrativeUnitWithReferenceRequest(String requestUrl, IBaseClient client, java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, AdministrativeUnit.class);
    }

    public void post(final AdministrativeUnit newAdministrativeUnit, final IJsonBackedObject payload, final ICallback<AdministrativeUnit> callback) {
        send(HttpMethod.POST, callback, payload);
    }

    public AdministrativeUnit post(final AdministrativeUnit newAdministrativeUnit, final IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = send(HttpMethod.POST, payload);
        if (response != null){
            return newAdministrativeUnit;
        }
        return null;
    }

    public void get(final ICallback<AdministrativeUnit> callback) {
        send(HttpMethod.GET, callback, null);
    }

    public AdministrativeUnit get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

	public void delete(final ICallback<AdministrativeUnit> callback) {
		send(HttpMethod.DELETE, callback, null);
	}

	public void delete() throws ClientException {
		send(HttpMethod.DELETE, null);
	}

	public void patch(final AdministrativeUnit sourceAdministrativeUnit, final ICallback<AdministrativeUnit> callback) {
		send(HttpMethod.PATCH, callback, sourceAdministrativeUnit);
	}

	public AdministrativeUnit patch(final AdministrativeUnit sourceAdministrativeUnit) throws ClientException {
		return send(HttpMethod.PATCH, sourceAdministrativeUnit);
	}

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IAdministrativeUnitWithReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (IAdministrativeUnitWithReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IAdministrativeUnitWithReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (AdministrativeUnitWithReferenceRequest)this;
    }
}
