// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Activity History Item Collection Request Builder.
 */
public class BaseActivityHistoryItemCollectionRequestBuilder extends BaseRequestBuilder implements IBaseActivityHistoryItemCollectionRequestBuilder {

    /**
     * The request builder for this collection of UserActivity
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseActivityHistoryItemCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IActivityHistoryItemCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IActivityHistoryItemCollectionRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new ActivityHistoryItemCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IActivityHistoryItemRequestBuilder byId(final String id) {
        return new ActivityHistoryItemRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }
}
