/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.GroupSetting;
import com.microsoft.graph.extensions.GroupSettingCollectionPage;
import com.microsoft.graph.extensions.GroupSettingCollectionRequest;
import com.microsoft.graph.extensions.GroupSettingCollectionRequestBuilder;
import com.microsoft.graph.extensions.GroupSettingRequestBuilder;
import com.microsoft.graph.extensions.IGroupSettingCollectionPage;
import com.microsoft.graph.extensions.IGroupSettingCollectionRequest;
import com.microsoft.graph.generated.BaseGroupSettingCollectionResponse;
import com.microsoft.graph.generated.IBaseGroupSettingCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseGroupSettingCollectionRequest
extends BaseCollectionRequest<BaseGroupSettingCollectionResponse, IGroupSettingCollectionPage>
implements IBaseGroupSettingCollectionRequest {
    public BaseGroupSettingCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseGroupSettingCollectionResponse.class, IGroupSettingCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IGroupSettingCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseGroupSettingCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupSettingCollectionPage get() throws ClientException {
        BaseGroupSettingCollectionResponse response = (BaseGroupSettingCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(GroupSetting newGroupSetting, ICallback<GroupSetting> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new GroupSettingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroupSetting, callback);
    }

    @Override
    public GroupSetting post(GroupSetting newGroupSetting) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupSettingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroupSetting);
    }

    @Override
    public IGroupSettingCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (GroupSettingCollectionRequest)this;
    }

    @Override
    public IGroupSettingCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (GroupSettingCollectionRequest)this;
    }

    @Override
    public IGroupSettingCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (GroupSettingCollectionRequest)this;
    }

    public IGroupSettingCollectionPage buildFromResponse(BaseGroupSettingCollectionResponse response) {
        GroupSettingCollectionRequestBuilder builder = response.nextLink != null ? new GroupSettingCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupSettingCollectionPage page = new GroupSettingCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

