/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.EducationClass;
import com.microsoft.graph.extensions.EducationClassCollectionReferenceRequest;
import com.microsoft.graph.extensions.EducationClassWithReferenceRequestBuilder;
import com.microsoft.graph.extensions.IEducationClassCollectionPage;
import com.microsoft.graph.extensions.IEducationClassCollectionReferenceRequest;
import com.microsoft.graph.generated.BaseEducationClassCollectionResponse;
import com.microsoft.graph.generated.IBaseEducationClassCollectionReferenceRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseEducationClassCollectionReferenceRequest
extends BaseCollectionRequest<BaseEducationClassCollectionResponse, IEducationClassCollectionPage>
implements IBaseEducationClassCollectionReferenceRequest {
    public BaseEducationClassCollectionReferenceRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEducationClassCollectionResponse.class, IEducationClassCollectionPage.class);
    }

    @Override
    public void post(EducationClass newEducationClass, ICallback<EducationClass> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/education/classes/" + newEducationClass.id);
        new EducationClassWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationClass, body, callback);
    }

    @Override
    public EducationClass post(EducationClass newEducationClass) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/education/classes/" + newEducationClass.id);
        return new EducationClassWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationClass, body);
    }

    public IEducationClassCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (EducationClassCollectionReferenceRequest)this;
    }

    @Override
    public IEducationClassCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (EducationClassCollectionReferenceRequest)this;
    }

    @Override
    public IEducationClassCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (EducationClassCollectionReferenceRequest)this;
    }
}

