/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.concurrency;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.concurrency.IProgressCallback;
import com.microsoft.graph.concurrency.SynchronousExecutor;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.logger.ILogger;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class DefaultExecutors
implements IExecutors {
    private final ThreadPoolExecutor mBackgroundExecutor;
    private final SynchronousExecutor mForegroundExecutor;
    private final ILogger mLogger;

    public DefaultExecutors(ILogger logger) {
        this.mLogger = logger;
        this.mBackgroundExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.mForegroundExecutor = new SynchronousExecutor();
    }

    @Override
    public void performOnBackground(Runnable runnable) {
        this.mLogger.logDebug("Starting background task, current active count: " + this.mBackgroundExecutor.getActiveCount());
        this.mBackgroundExecutor.execute(runnable);
    }

    @Override
    public <Result> void performOnForeground(final Result result, final ICallback<Result> callback) {
        this.mLogger.logDebug("Starting foreground task, current active count:" + this.mForegroundExecutor.getActiveCount() + ", with result " + result);
        this.mForegroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.success(result);
            }
        });
    }

    @Override
    public <Result> void performOnForeground(final int progress, final int progressMax, final IProgressCallback<Result> callback) {
        this.mLogger.logDebug("Starting foreground task, current active count:" + this.mForegroundExecutor.getActiveCount() + ", with progress  " + progress + ", max progress" + progressMax);
        this.mForegroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.progress(progress, progressMax);
            }
        });
    }

    @Override
    public <Result> void performOnForeground(final ClientException exception, final ICallback<Result> callback) {
        this.mLogger.logDebug("Starting foreground task, current active count:" + this.mForegroundExecutor.getActiveCount() + ", with exception " + exception);
        this.mForegroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.failure(exception);
            }
        });
    }
}

