// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Education Organization Request.
 */
public interface IBaseEducationOrganizationRequest extends IHttpRequest {

    /**
     * Gets the EducationOrganization from the service
     * @param callback The callback to be called after success or failure.
     */
    void getEducationOrganization(final ICallback<EducationOrganization> callback);

    /**
     * Gets the EducationOrganization from the service
     * @return The EducationOrganization from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationOrganization getEducationOrganization() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this EducationOrganization with a source
     * @param sourceEducationOrganization The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final EducationOrganization sourceEducationOrganization, final ICallback<EducationOrganization> callback);

    /**
     * Patches this EducationOrganization with a source
     * @param sourceEducationOrganization The source object with updates
     * @return The updated EducationOrganization
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationOrganization patch(final EducationOrganization sourceEducationOrganization) throws ClientException;

    /**
     * Posts a EducationOrganization with a new object
     * @param newEducationOrganization The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final EducationOrganization newEducationOrganization, final ICallback<EducationOrganization> callback);

    /**
     * Posts a EducationOrganization with a new object
     * @param newEducationOrganization The new object to create
     * @return The created EducationOrganization
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationOrganization post(final EducationOrganization newEducationOrganization) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseEducationOrganizationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseEducationOrganizationRequest expand(final String value);

}

