// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Content Type Request.
 */
public interface IBaseContentTypeRequest extends IHttpRequest {

    /**
     * Gets the ContentType from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<ContentType> callback);

    /**
     * Gets the ContentType from the service
     * @return The ContentType from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    ContentType get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ContentType with a source
     * @param sourceContentType The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final ContentType sourceContentType, final ICallback<ContentType> callback);

    /**
     * Patches this ContentType with a source
     * @param sourceContentType The source object with updates
     * @return The updated ContentType
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    ContentType patch(final ContentType sourceContentType) throws ClientException;

    /**
     * Posts a ContentType with a new object
     * @param newContentType The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final ContentType newContentType, final ICallback<ContentType> callback);

    /**
     * Posts a ContentType with a new object
     * @param newContentType The new object to create
     * @return The created ContentType
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    ContentType post(final ContentType newContentType) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseContentTypeRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseContentTypeRequest expand(final String value);

}

