// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Im Sub Request Builder.
 */
public class BaseWorkbookFunctionsImSubRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsImSub
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsImSubRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement inumber1, final com.google.gson.JsonElement inumber2) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("inumber1", inumber1);
        mBodyParams.put("inumber2", inumber2);
    }

    /**
     * Creates the IWorkbookFunctionsImSubRequest
     *
     * @return The IWorkbookFunctionsImSubRequest instance
     */
    public IWorkbookFunctionsImSubRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsImSubRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsImSubRequest instance
     */
    public IWorkbookFunctionsImSubRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsImSubRequest request = new WorkbookFunctionsImSubRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("inumber1")) {
            request.mBody.inumber1 = getParameter("inumber1");
        }

        if (hasParameter("inumber2")) {
            request.mBody.inumber2 = getParameter("inumber2");
        }

        return request;
    }
}
