// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Text Column.
 */
public class BaseTextColumn implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager getAdditionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Allow Multiple Lines.
     * Whether to allow multiple lines of text.
     */
    @SerializedName("allowMultipleLines")
    @Expose
    public Boolean allowMultipleLines;

    /**
     * The Append Changes To Existing Text.
     * Whether updates to this column should replace existing text, or append to it.
     */
    @SerializedName("appendChangesToExistingText")
    @Expose
    public Boolean appendChangesToExistingText;

    /**
     * The Lines For Editing.
     * The size of the text box.
     */
    @SerializedName("linesForEditing")
    @Expose
    public Integer linesForEditing;

    /**
     * The Max Length.
     * The maximum number of characters for the value.
     */
    @SerializedName("maxLength")
    @Expose
    public Integer maxLength;

    /**
     * The Text Type.
     * The type of text being stored. Must be one of plain or richText
     */
    @SerializedName("textType")
    @Expose
    public String textType;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
