// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Site Request.
 */
public class BaseSiteRequest extends BaseRequest implements IBaseSiteRequest {

    /**
     * The request for the Site
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseSiteRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the Site from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<Site> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Site from the service
     * @return The Site from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Site get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this Site with a source
     * @param sourceSite The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final Site sourceSite, final ICallback<Site> callback) {
        send(HttpMethod.PATCH, callback, sourceSite);
    }

    /**
     * Patches this Site with a source
     * @param sourceSite The source object with updates
     * @return The updated Site
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Site patch(final Site sourceSite) throws ClientException {
        return send(HttpMethod.PATCH, sourceSite);
    }

    /**
     * Creates a Site with a new object
     * @param newSite The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final Site newSite, final ICallback<Site> callback) {
        send(HttpMethod.POST, callback, newSite);
    }

    /**
     * Creates a Site with a new object
     * @param newSite The new object to create
     * @return The created Site
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Site post(final Site newSite) throws ClientException {
        return send(HttpMethod.POST, newSite);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public ISiteRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (SiteRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public ISiteRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (SiteRequest)this;
     }

}

