// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Group Reference Request.
 */
public class BaseGroupReferenceRequest extends BaseRequest implements IBaseGroupReferenceRequest {

    /**
     * The request for the Group
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseGroupReferenceRequest(String requestUrl, IBaseClient client, java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, Group.class);
    }

    public void delete(final ICallback<Group> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public Group delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IGroupReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (GroupReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IGroupReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (GroupReferenceRequest)this;
    }
    /**
     * Puts the Group
     *
     * @param srcGroup The Group reference to PUT
     * @param callback The callback to be called after success or failure
     */
    public void put(Group srcGroup, final ICallback<Group> callback) {
        send(HttpMethod.PUT, callback, srcGroup);
    }

    /**
     * Puts the Group
     *
     * @param srcGroup The Group reference to PUT
     * @return The Group
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
    public Group put(Group srcGroup) throws ClientException {
        return send(HttpMethod.PUT, srcGroup);
    }
}
