// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education Class Request.
 */
public class BaseEducationClassRequest extends BaseRequest implements IBaseEducationClassRequest {

    /**
     * The request for the EducationClass
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseEducationClassRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the EducationClass from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<EducationClass> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the EducationClass from the service
     * @return The EducationClass from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationClass get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this EducationClass with a source
     * @param sourceEducationClass The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final EducationClass sourceEducationClass, final ICallback<EducationClass> callback) {
        send(HttpMethod.PATCH, callback, sourceEducationClass);
    }

    /**
     * Patches this EducationClass with a source
     * @param sourceEducationClass The source object with updates
     * @return The updated EducationClass
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationClass patch(final EducationClass sourceEducationClass) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationClass);
    }

    /**
     * Creates a EducationClass with a new object
     * @param newEducationClass The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final EducationClass newEducationClass, final ICallback<EducationClass> callback) {
        send(HttpMethod.POST, callback, newEducationClass);
    }

    /**
     * Creates a EducationClass with a new object
     * @param newEducationClass The new object to create
     * @return The created EducationClass
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationClass post(final EducationClass newEducationClass) throws ClientException {
        return send(HttpMethod.POST, newEducationClass);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IEducationClassRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (EducationClassRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IEducationClassRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (EducationClassRequest)this;
     }

}

