/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Group;
import com.microsoft.graph.extensions.GroupCollectionPage;
import com.microsoft.graph.extensions.GroupCollectionRequest;
import com.microsoft.graph.extensions.GroupCollectionRequestBuilder;
import com.microsoft.graph.extensions.GroupRequestBuilder;
import com.microsoft.graph.extensions.IGroupCollectionPage;
import com.microsoft.graph.extensions.IGroupCollectionRequest;
import com.microsoft.graph.generated.BaseGroupCollectionResponse;
import com.microsoft.graph.generated.IBaseGroupCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseGroupCollectionRequest
extends BaseCollectionRequest<BaseGroupCollectionResponse, IGroupCollectionPage>
implements IBaseGroupCollectionRequest {
    public BaseGroupCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseGroupCollectionResponse.class, IGroupCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IGroupCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseGroupCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupCollectionPage get() throws ClientException {
        BaseGroupCollectionResponse response = (BaseGroupCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Group newGroup, ICallback<Group> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new GroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroup, callback);
    }

    @Override
    public Group post(Group newGroup) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroup);
    }

    @Override
    public IGroupCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (GroupCollectionRequest)this;
    }

    @Override
    public IGroupCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (GroupCollectionRequest)this;
    }

    @Override
    public IGroupCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (GroupCollectionRequest)this;
    }

    public IGroupCollectionPage buildFromResponse(BaseGroupCollectionResponse response) {
        GroupCollectionRequestBuilder builder = response.nextLink != null ? new GroupCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupCollectionPage page = new GroupCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

