// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Legend Format Request.
 */
public interface IBaseWorkbookChartLegendFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartLegendFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartLegendFormat> callback);

    /**
     * Gets the WorkbookChartLegendFormat from the service
     * @return The WorkbookChartLegendFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartLegendFormat get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartLegendFormat with a source
     * @param sourceWorkbookChartLegendFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartLegendFormat sourceWorkbookChartLegendFormat, final ICallback<WorkbookChartLegendFormat> callback);

    /**
     * Patches this WorkbookChartLegendFormat with a source
     * @param sourceWorkbookChartLegendFormat The source object with updates
     * @return The updated WorkbookChartLegendFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartLegendFormat patch(final WorkbookChartLegendFormat sourceWorkbookChartLegendFormat) throws ClientException;

    /**
     * Posts a WorkbookChartLegendFormat with a new object
     * @param newWorkbookChartLegendFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartLegendFormat newWorkbookChartLegendFormat, final ICallback<WorkbookChartLegendFormat> callback);

    /**
     * Posts a WorkbookChartLegendFormat with a new object
     * @param newWorkbookChartLegendFormat The new object to create
     * @return The created WorkbookChartLegendFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartLegendFormat post(final WorkbookChartLegendFormat newWorkbookChartLegendFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartLegendFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartLegendFormatRequest expand(final String value);

}

