// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Calendar Group Request.
 */
public interface IBaseCalendarGroupRequest extends IHttpRequest {

    /**
     * Gets the CalendarGroup from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<CalendarGroup> callback);

    /**
     * Gets the CalendarGroup from the service
     * @return The CalendarGroup from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    CalendarGroup get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this CalendarGroup with a source
     * @param sourceCalendarGroup The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final CalendarGroup sourceCalendarGroup, final ICallback<CalendarGroup> callback);

    /**
     * Patches this CalendarGroup with a source
     * @param sourceCalendarGroup The source object with updates
     * @return The updated CalendarGroup
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    CalendarGroup patch(final CalendarGroup sourceCalendarGroup) throws ClientException;

    /**
     * Posts a CalendarGroup with a new object
     * @param newCalendarGroup The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final CalendarGroup newCalendarGroup, final ICallback<CalendarGroup> callback);

    /**
     * Posts a CalendarGroup with a new object
     * @param newCalendarGroup The new object to create
     * @return The created CalendarGroup
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    CalendarGroup post(final CalendarGroup newCalendarGroup) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseCalendarGroupRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseCalendarGroupRequest expand(final String value);

}

