// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Table Sort Request.
 */
public class BaseWorkbookTableSortRequest extends BaseRequest implements IBaseWorkbookTableSortRequest {

    /**
     * The request for the WorkbookTableSort
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookTableSortRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookTableSort from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookTableSort> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookTableSort from the service
     * @return The WorkbookTableSort from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookTableSort get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookTableSort with a source
     * @param sourceWorkbookTableSort The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookTableSort sourceWorkbookTableSort, final ICallback<WorkbookTableSort> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookTableSort);
    }

    /**
     * Patches this WorkbookTableSort with a source
     * @param sourceWorkbookTableSort The source object with updates
     * @return The updated WorkbookTableSort
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookTableSort patch(final WorkbookTableSort sourceWorkbookTableSort) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookTableSort);
    }

    /**
     * Creates a WorkbookTableSort with a new object
     * @param newWorkbookTableSort The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookTableSort newWorkbookTableSort, final ICallback<WorkbookTableSort> callback) {
        send(HttpMethod.POST, callback, newWorkbookTableSort);
    }

    /**
     * Creates a WorkbookTableSort with a new object
     * @param newWorkbookTableSort The new object to create
     * @return The created WorkbookTableSort
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookTableSort post(final WorkbookTableSort newWorkbookTableSort) throws ClientException {
        return send(HttpMethod.POST, newWorkbookTableSort);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookTableSortRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookTableSortRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookTableSortRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookTableSortRequest)this;
     }

}

