// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Fvschedule Request Builder.
 */
public class BaseWorkbookFunctionsFvscheduleRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsFvschedule
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsFvscheduleRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement principal, final com.google.gson.JsonElement schedule) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("principal", principal);
        mBodyParams.put("schedule", schedule);
    }

    /**
     * Creates the IWorkbookFunctionsFvscheduleRequest
     *
     * @return The IWorkbookFunctionsFvscheduleRequest instance
     */
    public IWorkbookFunctionsFvscheduleRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsFvscheduleRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsFvscheduleRequest instance
     */
    public IWorkbookFunctionsFvscheduleRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsFvscheduleRequest request = new WorkbookFunctionsFvscheduleRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("principal")) {
            request.mBody.principal = getParameter("principal");
        }

        if (hasParameter("schedule")) {
            request.mBody.schedule = getParameter("schedule");
        }

        return request;
    }
}
