// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Point Format Request.
 */
public class BaseWorkbookChartPointFormatRequest extends BaseRequest implements IBaseWorkbookChartPointFormatRequest {

    /**
     * The request for the WorkbookChartPointFormat
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookChartPointFormatRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookChartPointFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookChartPointFormat> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartPointFormat from the service
     * @return The WorkbookChartPointFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartPointFormat get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookChartPointFormat with a source
     * @param sourceWorkbookChartPointFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookChartPointFormat sourceWorkbookChartPointFormat, final ICallback<WorkbookChartPointFormat> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookChartPointFormat);
    }

    /**
     * Patches this WorkbookChartPointFormat with a source
     * @param sourceWorkbookChartPointFormat The source object with updates
     * @return The updated WorkbookChartPointFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartPointFormat patch(final WorkbookChartPointFormat sourceWorkbookChartPointFormat) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartPointFormat);
    }

    /**
     * Creates a WorkbookChartPointFormat with a new object
     * @param newWorkbookChartPointFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookChartPointFormat newWorkbookChartPointFormat, final ICallback<WorkbookChartPointFormat> callback) {
        send(HttpMethod.POST, callback, newWorkbookChartPointFormat);
    }

    /**
     * Creates a WorkbookChartPointFormat with a new object
     * @param newWorkbookChartPointFormat The new object to create
     * @return The created WorkbookChartPointFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartPointFormat post(final WorkbookChartPointFormat newWorkbookChartPointFormat) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartPointFormat);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookChartPointFormatRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookChartPointFormatRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookChartPointFormatRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookChartPointFormatRequest)this;
     }

}

