// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Shared Drive Item.
 */
public class BaseSharedDriveItem extends BaseItem implements IJsonBackedObject {


    public BaseSharedDriveItem() {
        oDataType = "microsoft.graph.sharedDriveItem";
    }

    /**
     * The Owner.
     * Information about the owner of the shared item being referenced.
     */
    @SerializedName("owner")
    @Expose
    public IdentitySet owner;

    /**
     * The Drive Item.
     * A driveItem for the resource that was shared.  This is identical to the root property.
     */
    @SerializedName("driveItem")
    @Expose
    public DriveItem driveItem;

    /**
     * The Items.
     * A collection of shared driveItem resources. This collection cannot be enumerated, but items can be accessed by their unique ID.
     */
    public transient DriveItemCollectionPage items;

    /**
     * The List.
     * 
     */
    @SerializedName("list")
    @Expose
    public List list;

    /**
     * The List Item.
     * 
     */
    @SerializedName("listItem")
    @Expose
    public ListItem listItem;

    /**
     * The Root.
     * The top level shared driveItem. If a single file is shared, this item is the file. If a folder is shared, this item will be the folder. You can use the item's facets to determine which case applies.
     */
    @SerializedName("root")
    @Expose
    public DriveItem root;

    /**
     * The Site.
     * A site resource that contains the item that was shared.
     */
    @SerializedName("site")
    @Expose
    public Site site;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;


        if (json.has("items")) {
            final BaseDriveItemCollectionResponse response = new BaseDriveItemCollectionResponse();
            if (json.has("items@odata.nextLink")) {
                response.nextLink = json.get("items@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("items").toString(), JsonObject[].class);
            final DriveItem[] array = new DriveItem[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DriveItem.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            items = new DriveItemCollectionPage(response, null);
        }
    }
}
