// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Section Group Collection Request Builder.
 */
public class BaseSectionGroupCollectionRequestBuilder extends BaseRequestBuilder implements IBaseSectionGroupCollectionRequestBuilder {

    /**
     * The request builder for this collection of SectionGroup
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseSectionGroupCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public ISectionGroupCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public ISectionGroupCollectionRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new SectionGroupCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public ISectionGroupRequestBuilder byId(final String id) {
        return new SectionGroupRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }
}
