// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Planner Category Descriptions.
 */
public class BasePlannerCategoryDescriptions implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose(serialize = false)
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager getAdditionalDataManager() {
        return additionalDataManager;
    }

    public BasePlannerCategoryDescriptions() {
        oDataType = "microsoft.graph.plannerCategoryDescriptions";
    }

    /**
     * The Category1.
     * The label associated with Category 1
     */
    @SerializedName("category1")
    @Expose
    public String category1;

    /**
     * The Category2.
     * The label associated with Category 2
     */
    @SerializedName("category2")
    @Expose
    public String category2;

    /**
     * The Category3.
     * The label associated with Category 3
     */
    @SerializedName("category3")
    @Expose
    public String category3;

    /**
     * The Category4.
     * The label associated with Category 4
     */
    @SerializedName("category4")
    @Expose
    public String category4;

    /**
     * The Category5.
     * The label associated with Category 5
     */
    @SerializedName("category5")
    @Expose
    public String category5;

    /**
     * The Category6.
     * The label associated with Category 6
     */
    @SerializedName("category6")
    @Expose
    public String category6;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
