// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Organization.
 */
public class BaseOrganization extends DirectoryObject implements IJsonBackedObject {


    public BaseOrganization() {
        oDataType = "microsoft.graph.organization";
    }

    /**
     * The Assigned Plans.
     * The collection of service plans associated with the tenant. Not nullable.
     */
    @SerializedName("assignedPlans")
    @Expose
    public java.util.List<AssignedPlan> assignedPlans;

    /**
     * The Business Phones.
     * 
     */
    @SerializedName("businessPhones")
    @Expose
    public java.util.List<String> businessPhones;

    /**
     * The City.
     * 
     */
    @SerializedName("city")
    @Expose
    public String city;

    /**
     * The Country.
     * 
     */
    @SerializedName("country")
    @Expose
    public String country;

    /**
     * The Country Letter Code.
     * 
     */
    @SerializedName("countryLetterCode")
    @Expose
    public String countryLetterCode;

    /**
     * The Display Name.
     * The display name for the tenant.
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Marketing Notification Emails.
     * Not nullable.
     */
    @SerializedName("marketingNotificationEmails")
    @Expose
    public java.util.List<String> marketingNotificationEmails;

    /**
     * The On Premises Last Sync Date Time.
     * 
     */
    @SerializedName("onPremisesLastSyncDateTime")
    @Expose
    public java.util.Calendar onPremisesLastSyncDateTime;

    /**
     * The On Premises Sync Enabled.
     * 
     */
    @SerializedName("onPremisesSyncEnabled")
    @Expose
    public Boolean onPremisesSyncEnabled;

    /**
     * The Postal Code.
     * 
     */
    @SerializedName("postalCode")
    @Expose
    public String postalCode;

    /**
     * The Preferred Language.
     * 
     */
    @SerializedName("preferredLanguage")
    @Expose
    public String preferredLanguage;

    /**
     * The Provisioned Plans.
     * Not nullable.
     */
    @SerializedName("provisionedPlans")
    @Expose
    public java.util.List<ProvisionedPlan> provisionedPlans;

    /**
     * The Security Compliance Notification Mails.
     * 
     */
    @SerializedName("securityComplianceNotificationMails")
    @Expose
    public java.util.List<String> securityComplianceNotificationMails;

    /**
     * The Security Compliance Notification Phones.
     * 
     */
    @SerializedName("securityComplianceNotificationPhones")
    @Expose
    public java.util.List<String> securityComplianceNotificationPhones;

    /**
     * The State.
     * 
     */
    @SerializedName("state")
    @Expose
    public String state;

    /**
     * The Street.
     * 
     */
    @SerializedName("street")
    @Expose
    public String street;

    /**
     * The Technical Notification Mails.
     * Not nullable.
     */
    @SerializedName("technicalNotificationMails")
    @Expose
    public java.util.List<String> technicalNotificationMails;

    /**
     * The Verified Domains.
     * The collection of domains associated with this tenant. Not nullable.
     */
    @SerializedName("verifiedDomains")
    @Expose
    public java.util.List<VerifiedDomain> verifiedDomains;

    /**
     * The Extensions.
     * The collection of open extensions defined for the organization. Read-only. Nullable.
     */
    public transient ExtensionCollectionPage extensions;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;


        if (json.has("extensions")) {
            final BaseExtensionCollectionResponse response = new BaseExtensionCollectionResponse();
            if (json.has("extensions@odata.nextLink")) {
                response.nextLink = json.get("extensions@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("extensions").toString(), JsonObject[].class);
            final Extension[] array = new Extension[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Extension.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            extensions = new ExtensionCollectionPage(response, null);
        }
    }
}
