// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base File Attachment.
 */
public class BaseFileAttachment extends Attachment implements IJsonBackedObject {


    public BaseFileAttachment() {
        oDataType = "microsoft.graph.fileAttachment";
    }

    /**
     * The Content Id.
     * The ID of the attachment in the Exchange store.
     */
    @SerializedName("contentId")
    @Expose
    public String contentId;

    /**
     * The Content Location.
     * The Uniform Resource Identifier (URI) that corresponds to the location of the content of the attachment.
     */
    @SerializedName("contentLocation")
    @Expose
    public String contentLocation;

    /**
     * The Content Bytes.
     * The binary contents of the file.
     */
    @SerializedName("contentBytes")
    @Expose
    public byte[] contentBytes;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
