// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Extension Collection Request.
 */
public class BaseExtensionCollectionRequest extends BaseCollectionRequest<BaseExtensionCollectionResponse, IExtensionCollectionPage> implements IBaseExtensionCollectionRequest {

    /**
     * The request builder for this collection of Extension
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseExtensionCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseExtensionCollectionResponse.class, IExtensionCollectionPage.class);
    }

    public void get(final ICallback<IExtensionCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IExtensionCollectionPage get() throws ClientException {
        final BaseExtensionCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Extension newExtension, final ICallback<Extension> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ExtensionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newExtension, callback);
    }

    public Extension post(final Extension newExtension) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ExtensionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newExtension);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IExtensionCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ExtensionCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IExtensionCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ExtensionCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IExtensionCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ExtensionCollectionRequest)this;
    }

    public IExtensionCollectionPage buildFromResponse(final BaseExtensionCollectionResponse response) {
        final IExtensionCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ExtensionCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ExtensionCollectionPage page = new ExtensionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
