// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Group Setting Template Request.
 */
public interface IBaseGroupSettingTemplateRequest extends IHttpRequest {

    /**
     * Gets the GroupSettingTemplate from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<GroupSettingTemplate> callback);

    /**
     * Gets the GroupSettingTemplate from the service
     * @return The GroupSettingTemplate from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    GroupSettingTemplate get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this GroupSettingTemplate with a source
     * @param sourceGroupSettingTemplate The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final GroupSettingTemplate sourceGroupSettingTemplate, final ICallback<GroupSettingTemplate> callback);

    /**
     * Patches this GroupSettingTemplate with a source
     * @param sourceGroupSettingTemplate The source object with updates
     * @return The updated GroupSettingTemplate
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    GroupSettingTemplate patch(final GroupSettingTemplate sourceGroupSettingTemplate) throws ClientException;

    /**
     * Posts a GroupSettingTemplate with a new object
     * @param newGroupSettingTemplate The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final GroupSettingTemplate newGroupSettingTemplate, final ICallback<GroupSettingTemplate> callback);

    /**
     * Posts a GroupSettingTemplate with a new object
     * @param newGroupSettingTemplate The new object to create
     * @return The created GroupSettingTemplate
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    GroupSettingTemplate post(final GroupSettingTemplate newGroupSettingTemplate) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseGroupSettingTemplateRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseGroupSettingTemplateRequest expand(final String value);

}
